/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.AbstractInterleavedBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.InterleavedBlock;
import com.facebook.presto.jdbc.internal.spi.block.InterleavedBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class InterleavedBlockBuilder
extends AbstractInterleavedBlock
implements BlockBuilder {
    private final BlockBuilder[] blockBuilders;
    private final InterleavedBlockEncoding blockEncoding;
    private int positionCount;
    private int currentBlockIndex;
    private int sizeInBytes;
    private int startSize;
    private int retainedSizeInBytes;
    private int startRetainedSize;

    public InterleavedBlockBuilder(List<Type> types, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this((BlockBuilder[])types.stream().map(t -> t.createBlockBuilder(blockBuilderStatus, expectedEntries)).toArray(BlockBuilder[]::new));
    }

    public InterleavedBlockBuilder(List<Type> types, BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        this((BlockBuilder[])types.stream().map(t -> t.createBlockBuilder(blockBuilderStatus, expectedEntries, expectedBytesPerEntry)).toArray(BlockBuilder[]::new));
    }

    private InterleavedBlockBuilder(BlockBuilder[] blockBuilders) {
        super(blockBuilders.length);
        this.blockBuilders = Objects.requireNonNull(blockBuilders, "blockBuilders is null");
        this.blockEncoding = this.computeBlockEncoding();
        this.positionCount = 0;
        this.sizeInBytes = 0;
        this.retainedSizeInBytes = 0;
        for (BlockBuilder blockBuilder : blockBuilders) {
            this.sizeInBytes += blockBuilder.getSizeInBytes();
            this.retainedSizeInBytes += blockBuilder.getRetainedSizeInBytes();
        }
        this.startSize = -1;
        this.startRetainedSize = -1;
    }

    @Override
    protected Block getBlock(int blockIndex) {
        if (blockIndex < 0) {
            throw new IllegalArgumentException("position is not valid");
        }
        return this.blockBuilders[blockIndex];
    }

    @Override
    public InterleavedBlockEncoding getEncoding() {
        return this.blockEncoding;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    private void recordStartSizesIfNecessary(BlockBuilder blockBuilder) {
        if (this.startSize < 0) {
            this.startSize = blockBuilder.getSizeInBytes();
        }
        if (this.startRetainedSize < 0) {
            this.startRetainedSize = blockBuilder.getRetainedSizeInBytes();
        }
    }

    @Override
    public BlockBuilder writeByte(int value) {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        this.recordStartSizesIfNecessary(blockBuilder);
        blockBuilder.writeByte(value);
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        this.recordStartSizesIfNecessary(blockBuilder);
        blockBuilder.writeShort(value);
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        this.recordStartSizesIfNecessary(blockBuilder);
        blockBuilder.writeInt(value);
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        this.recordStartSizesIfNecessary(blockBuilder);
        blockBuilder.writeLong(value);
        return this;
    }

    @Override
    public BlockBuilder writeFloat(float value) {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        this.recordStartSizesIfNecessary(blockBuilder);
        blockBuilder.writeFloat(value);
        return this;
    }

    @Override
    public BlockBuilder writeDouble(double value) {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        this.recordStartSizesIfNecessary(blockBuilder);
        blockBuilder.writeDouble(value);
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        this.recordStartSizesIfNecessary(blockBuilder);
        blockBuilder.writeBytes(source, sourceIndex, length);
        return this;
    }

    @Override
    public BlockBuilder writeObject(Object value) {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        this.recordStartSizesIfNecessary(blockBuilder);
        blockBuilder.writeObject(value);
        return this;
    }

    @Override
    public BlockBuilder beginBlockEntry() {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        this.recordStartSizesIfNecessary(blockBuilder);
        return blockBuilder.beginBlockEntry();
    }

    @Override
    public BlockBuilder closeEntry() {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        if (this.startSize < 0 || this.startRetainedSize < 0) {
            throw new IllegalStateException("closeEntry called before anything is written");
        }
        blockBuilder.closeEntry();
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        if (this.startSize >= 0 || this.startRetainedSize >= 0) {
            throw new IllegalStateException("appendNull called when some entry has been written");
        }
        this.startSize = blockBuilder.getSizeInBytes();
        this.startRetainedSize = blockBuilder.getRetainedSizeInBytes();
        blockBuilder.appendNull();
        this.entryAdded();
        return this;
    }

    private void entryAdded() {
        BlockBuilder blockBuilder = this.blockBuilders[this.currentBlockIndex];
        this.sizeInBytes += blockBuilder.getSizeInBytes() - this.startSize;
        this.retainedSizeInBytes += blockBuilder.getRetainedSizeInBytes() - this.startRetainedSize;
        this.startSize = -1;
        this.startRetainedSize = -1;
        ++this.positionCount;
        ++this.currentBlockIndex;
        if (this.currentBlockIndex == this.getBlockCount()) {
            this.currentBlockIndex = 0;
        }
    }

    @Override
    public InterleavedBlock build() {
        Block[] blocks = new Block[this.getBlockCount()];
        for (int i = 0; i < this.getBlockCount(); ++i) {
            blocks[i] = this.blockBuilders[i].build();
        }
        return new InterleavedBlock(blocks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InterleavedBlock{");
        sb.append("columns=").append(this.getBlockCount());
        sb.append(", positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

