/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.stats.CounterStat;
import com.facebook.presto.jdbc.internal.airlift.stats.DistributionStat;
import com.facebook.presto.jdbc.internal.airlift.stats.TimeStat;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@Beta
public class RequestStats {
    private final CounterStat request = new CounterStat();
    private final TimeStat requestTime = new TimeStat();
    private final TimeStat responseTime = new TimeStat();
    private final DistributionStat readBytes = new DistributionStat();
    private final DistributionStat writtenBytes = new DistributionStat();

    @Inject
    public RequestStats() {
    }

    public void record(String method, int responseCode, long requestSizeInBytes, long responseSizeInBytes, Duration requestProcessingTime, Duration responseProcessingTime) {
        this.request.update(1L);
        if (requestProcessingTime != null) {
            this.requestTime.add(requestProcessingTime);
        }
        if (responseProcessingTime != null) {
            this.responseTime.add(responseProcessingTime);
        }
        this.readBytes.add(responseSizeInBytes);
        this.writtenBytes.add(requestSizeInBytes);
    }

    @Managed
    @Flatten
    public CounterStat getRequest() {
        return this.request;
    }

    @Managed
    @Nested
    public TimeStat getRequestTime() {
        return this.requestTime;
    }

    @Managed
    @Nested
    public TimeStat getResponseTime() {
        return this.responseTime;
    }

    @Managed
    @Nested
    public DistributionStat getReadBytes() {
        return this.readBytes;
    }

    @Managed
    @Nested
    public DistributionStat getWrittenBytes() {
        return this.writtenBytes;
    }
}

