/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.Page;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.PageBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PageBuilder {
    private final BlockBuilder[] blockBuilders;
    private final List<Type> types;
    private PageBuilderStatus pageBuilderStatus;
    private int declaredPositions;

    public PageBuilder(List<? extends Type> types) {
        int maxBlockSizeInBytes;
        this.types = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(types, "types is null")));
        if (!types.isEmpty()) {
            maxBlockSizeInBytes = (int)(1048576.0 / (double)types.size());
            maxBlockSizeInBytes = Math.min(65536, maxBlockSizeInBytes);
        } else {
            maxBlockSizeInBytes = 0;
        }
        this.pageBuilderStatus = new PageBuilderStatus(0x100000, maxBlockSizeInBytes);
        this.blockBuilders = new BlockBuilder[types.size()];
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            this.blockBuilders[i] = types.get(i).createBlockBuilder(this.pageBuilderStatus.createBlockBuilderStatus(), 1, this.pageBuilderStatus.getMaxBlockSizeInBytes());
        }
    }

    public void reset() {
        if (this.isEmpty()) {
            return;
        }
        this.declaredPositions = 0;
        this.pageBuilderStatus = new PageBuilderStatus(this.pageBuilderStatus.getMaxPageSizeInBytes(), this.pageBuilderStatus.getMaxBlockSizeInBytes());
        for (int i = 0; i < this.types.size(); ++i) {
            this.blockBuilders[i] = this.types.get(i).createBlockBuilder(this.pageBuilderStatus.createBlockBuilderStatus(), 1, this.pageBuilderStatus.getMaxBlockSizeInBytes());
        }
    }

    public BlockBuilder getBlockBuilder(int channel) {
        return this.blockBuilders[channel];
    }

    public void declarePosition() {
        ++this.declaredPositions;
    }

    public boolean isFull() {
        return this.declaredPositions == Integer.MAX_VALUE || this.pageBuilderStatus.isFull();
    }

    public boolean isEmpty() {
        return this.declaredPositions == 0;
    }

    public int getPositionCount() {
        return this.declaredPositions;
    }

    public long getSizeInBytes() {
        return this.pageBuilderStatus.getSizeInBytes();
    }

    public Page build() {
        if (this.blockBuilders.length == 0) {
            return new Page(this.declaredPositions, new Block[0]);
        }
        Block[] blocks = new Block[this.blockBuilders.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.blockBuilders[i].build();
            if (blocks[i].getPositionCount() == this.declaredPositions) continue;
            throw new IllegalStateException(String.format("Declared positions (%s) does not match block %s's number of entries (%s)", this.declaredPositions, i, blocks[i].getPositionCount()));
        }
        return new Page(blocks);
    }
}

