/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockValidationUtil;
import com.facebook.presto.jdbc.internal.spi.block.DictionaryBlock;
import com.facebook.presto.jdbc.internal.spi.block.LazyBlockLoader;
import com.facebook.presto.jdbc.internal.spi.block.LazySliceArrayBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.SliceArrayBlock;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LazySliceArrayBlock
extends AbstractVariableWidthBlock {
    private final int positionCount;
    private final AtomicInteger sizeInBytes = new AtomicInteger(-1);
    private LazyBlockLoader<LazySliceArrayBlock> loader;
    private Slice[] values;
    private boolean dictionary;
    private int[] ids;
    private boolean[] isNull;

    public LazySliceArrayBlock(int positionCount, LazyBlockLoader<LazySliceArrayBlock> loader) {
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.loader = Objects.requireNonNull(loader);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new LazySliceArrayBlockEncoding();
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockValidationUtil.checkValidPositions(positions, this.positionCount);
        this.assureLoaded();
        if (this.dictionary) {
            return this.compactAndGet(positions, false);
        }
        Slice[] newValues = new Slice[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            if (this.isEntryNull(positions.get(i))) continue;
            newValues[i] = Slices.copyOf(this.values[positions.get(i)]);
        }
        return new SliceArrayBlock(positions.size(), newValues);
    }

    @Override
    protected Slice getRawSlice(int position) {
        this.assureLoaded();
        return this.values[this.getPosition(position)];
    }

    @Override
    protected int getPositionOffset(int position) {
        return 0;
    }

    @Override
    protected boolean isEntryNull(int position) {
        this.assureLoaded();
        if (this.isNull != null) {
            return this.isNull[position];
        }
        return this.values[this.getPosition(position)] == null;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getLength(int position) {
        this.assureLoaded();
        return this.values[this.getPosition(position)].length();
    }

    @Override
    public int getSizeInBytes() {
        int sizeInBytes = this.sizeInBytes.get();
        if (sizeInBytes < 0) {
            this.assureLoaded();
            sizeInBytes = SliceArrayBlock.getSliceArraySizeInBytes(this.values);
            if (this.dictionary) {
                sizeInBytes += this.ids.length * 4;
                sizeInBytes += this.isNull.length * 1;
            }
            this.sizeInBytes.set(sizeInBytes);
        }
        return sizeInBytes;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.getSizeInBytes();
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        this.assureLoaded();
        if (this.dictionary) {
            List<Integer> positions = IntStream.range(positionOffset, positionOffset + length).boxed().collect(Collectors.toList());
            this.compactAndGet(positions, false);
        }
        Slice[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new SliceArrayBlock(length, newValues);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        this.assureLoaded();
        if (this.dictionary) {
            List<Integer> positions = IntStream.range(positionOffset, positionOffset + length).boxed().collect(Collectors.toList());
            return this.compactAndGet(positions, true);
        }
        return new SliceArrayBlock(length, SliceArrayBlock.deepCopyAndCompact(this.values, positionOffset, length));
    }

    @Override
    public void assureLoaded() {
        if (this.values != null) {
            return;
        }
        this.loader.load(this);
        if (this.values == null) {
            throw new IllegalArgumentException("Lazy block loader did not load this block");
        }
        if (this.dictionary && this.ids.length != this.positionCount) {
            throw new IllegalArgumentException(String.format("Expected %s positions, loaded %s", this.positionCount, this.ids.length));
        }
        if (!this.dictionary && this.values.length != this.positionCount) {
            throw new IllegalArgumentException(String.format("Expected %s positions, loaded %s", this.positionCount, this.values.length));
        }
        this.loader = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LazySliceArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    private Block compactAndGet(List<Integer> positions, boolean copy) {
        List distinctPositions = positions.stream().distinct().collect(Collectors.toList());
        List currentDictionaryIndexes = distinctPositions.stream().map(this::getPosition).collect(Collectors.toList());
        List positionsToCopy = currentDictionaryIndexes.stream().distinct().collect(Collectors.toList());
        Slice[] newValues = new Slice[positionsToCopy.size()];
        for (int i = 0; i < positionsToCopy.size(); ++i) {
            int position = (Integer)positionsToCopy.get(i);
            if (this.isEntryNull(position)) {
                newValues[i] = null;
                continue;
            }
            Slice value = this.values[position];
            newValues[i] = copy ? Slices.copyOf(value) : value;
        }
        int[] newIds = new int[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            int oldIndex = (Integer)currentDictionaryIndexes.get(distinctPositions.indexOf(positions.get(i)));
            newIds[i] = positionsToCopy.indexOf(oldIndex);
        }
        return new DictionaryBlock(positions.size(), new SliceArrayBlock(newValues.length, newValues), Slices.wrappedIntArray(newIds));
    }

    private int getPosition(int position) {
        if (this.dictionary) {
            return this.ids[position];
        }
        return position;
    }

    public Slice[] getValues() {
        this.assureLoaded();
        return this.values;
    }

    public int[] getIds() {
        return this.ids;
    }

    public boolean isDictionary() {
        this.assureLoaded();
        return this.dictionary;
    }

    public void setValues(Slice[] values) {
        Objects.requireNonNull(values, "values is null");
        this.values = values;
    }

    public void setValues(Slice[] values, int[] ids, boolean[] isNull) {
        Objects.requireNonNull(values, "values is null");
        Objects.requireNonNull(ids, "ids is null");
        Objects.requireNonNull(isNull, "isNull is null");
        if (ids.length != this.positionCount) {
            throw new IllegalArgumentException(String.format("ids length %s is not equal to positionCount %s", ids.length, this.positionCount));
        }
        if (ids.length != isNull.length) {
            throw new IllegalArgumentException("ids length does not match isNull length");
        }
        this.setValues(values);
        this.ids = ids;
        this.isNull = isNull;
        this.dictionary = true;
    }

    public Block createNonLazyBlock() {
        this.assureLoaded();
        if (!this.dictionary) {
            return new SliceArrayBlock(this.getPositionCount(), this.values);
        }
        if (this.isNull == null) {
            return new DictionaryBlock(this.getPositionCount(), new SliceArrayBlock(this.values.length, this.values), Slices.wrappedIntArray(this.ids));
        }
        boolean hasNulls = false;
        int[] newIds = Arrays.copyOf(this.ids, this.ids.length);
        for (int position = 0; position < this.positionCount; ++position) {
            if (!this.isEntryNull(position)) continue;
            hasNulls = true;
            newIds[position] = this.values.length;
        }
        Slice[] newValues = hasNulls ? Arrays.copyOf(this.values, this.values.length + 1) : this.values;
        return new DictionaryBlock(this.getPositionCount(), new SliceArrayBlock(newValues.length, newValues), Slices.wrappedIntArray(newIds));
    }
}

