/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.Locale;
import java.util.Objects;

public class ColumnMetadata {
    private final String name;
    private final Type type;
    private final boolean partitionKey;
    private final String comment;
    private final boolean hidden;

    public ColumnMetadata(String name, Type type, boolean partitionKey) {
        this(name, type, partitionKey, null, false);
    }

    public ColumnMetadata(String name, Type type, boolean partitionKey, String comment, boolean hidden) {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("name is null or empty");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.type = type;
        this.partitionKey = partitionKey;
        this.comment = comment;
        this.hidden = hidden;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnMetadata{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", type=").append(this.type);
        sb.append(", partitionKey=").append(this.partitionKey);
        if (this.comment != null) {
            sb.append(", comment='").append(this.comment).append('\'');
        }
        if (this.hidden) {
            sb.append(", hidden");
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.partitionKey, this.comment, this.hidden);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnMetadata other = (ColumnMetadata)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.partitionKey, other.partitionKey) && Objects.equals(this.comment, other.comment) && Objects.equals(this.hidden, other.hidden);
    }
}

