/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.json;

import com.facebook.presto.jdbc.internal.airlift.json.JsonKeySerde;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.KeyDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.Module;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.util.Objects;

public class JsonBinder {
    private final MapBinder<Class<?>, JsonSerializer<?>> keySerializerMapBinder;
    private final MapBinder<Class<?>, KeyDeserializer> keyDeserializerMapBinder;
    private final MapBinder<Class<?>, JsonSerializer<?>> serializerMapBinder;
    private final MapBinder<Class<?>, JsonDeserializer<?>> deserializerMapBinder;
    private final Multibinder<Module> moduleBinder;

    public static JsonBinder jsonBinder(Binder binder) {
        return new JsonBinder(binder);
    }

    private JsonBinder(Binder binder) {
        binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
        this.keySerializerMapBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<JsonSerializer<?>>(){}, JsonKeySerde.class);
        this.keyDeserializerMapBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<KeyDeserializer>(){}, JsonKeySerde.class);
        this.serializerMapBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<JsonSerializer<?>>(){});
        this.deserializerMapBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<JsonDeserializer<?>>(){});
        this.moduleBinder = Multibinder.newSetBinder((Binder)binder, Module.class);
    }

    public LinkedBindingBuilder<JsonSerializer<?>> addKeySerializerBinding(Class<?> type) {
        Preconditions.checkNotNull(type, "type is null");
        return this.keySerializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<KeyDeserializer> addKeyDeserializerBinding(Class<?> type) {
        Preconditions.checkNotNull(type, "type is null");
        return this.keyDeserializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<JsonSerializer<?>> addSerializerBinding(Class<?> type) {
        Preconditions.checkNotNull(type, "type is null");
        return this.serializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<JsonDeserializer<?>> addDeserializerBinding(Class<?> type) {
        Preconditions.checkNotNull(type, "type is null");
        return this.deserializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<Module> addModuleBinding() {
        return this.moduleBinder.addBinding();
    }

    public <T> void bindSerializer(JsonSerializer<T> jsonSerializer) {
        Preconditions.checkNotNull(jsonSerializer, "jsonSerializer is null");
        Class<T> type = jsonSerializer.handledType();
        Preconditions.checkNotNull(type, "jsonSerializer.handledType is null");
        Preconditions.checkArgument(type == Object.class, "jsonSerializer.handledType can not be Object.class");
        this.serializerMapBinder.addBinding(type).toInstance(jsonSerializer);
    }
}

