/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.guava.cache;

import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.cache.RemovalListener;
import com.facebook.presto.jdbc.internal.guava.cache.RemovalNotification;
import java.util.concurrent.Executor;

@Beta
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

