/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.spi.block.PageBuilderStatus;
import java.util.Objects;

public class BlockBuilderStatus {
    public static final int DEFAULT_MAX_BLOCK_SIZE_IN_BYTES = 65536;
    private final PageBuilderStatus pageBuilderStatus;
    private final int maxBlockSizeInBytes;
    private int currentSize;

    public BlockBuilderStatus() {
        this(new PageBuilderStatus(0x100000, 65536), 65536);
    }

    BlockBuilderStatus(PageBuilderStatus pageBuilderStatus, int maxBlockSizeInBytes) {
        this.pageBuilderStatus = Objects.requireNonNull(pageBuilderStatus, "pageBuilderStatus must not be null");
        this.maxBlockSizeInBytes = maxBlockSizeInBytes;
    }

    public int getMaxBlockSizeInBytes() {
        return this.maxBlockSizeInBytes;
    }

    public void addBytes(int bytes) {
        this.currentSize += bytes;
        this.pageBuilderStatus.addBytes(bytes);
        if (this.currentSize >= this.maxBlockSizeInBytes) {
            this.pageBuilderStatus.setFull();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("BlockBuilderStatus{");
        buffer.append("maxSizeInBytes=").append(this.maxBlockSizeInBytes);
        buffer.append(", currentSize=").append(this.currentSize);
        buffer.append('}');
        return buffer.toString();
    }
}

