/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.jsr310.deser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationFeature;
import com.facebook.presto.jdbc.internal.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.LocalDateTime;

public class LocalDateTimeDeserializer
extends JSR310DeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();

    private LocalDateTimeDeserializer() {
        super(LocalDateTime.class);
    }

    @Override
    public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentToken()) {
            case START_ARRAY: {
                if (parser.nextToken() == JsonToken.END_ARRAY) {
                    return null;
                }
                int year = parser.getIntValue();
                parser.nextToken();
                int month = parser.getIntValue();
                parser.nextToken();
                int day = parser.getIntValue();
                parser.nextToken();
                int hour = parser.getIntValue();
                parser.nextToken();
                int minute = parser.getIntValue();
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    int second = parser.getIntValue();
                    if (parser.nextToken() != JsonToken.END_ARRAY) {
                        int partialSecond = parser.getIntValue();
                        if (partialSecond < 1000 && !context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            partialSecond *= 1000000;
                        }
                        if (parser.nextToken() != JsonToken.END_ARRAY) {
                            throw context.wrongTokenException(parser, JsonToken.END_ARRAY, "Expected array to end.");
                        }
                        return LocalDateTime.of(year, month, day, hour, minute, second, partialSecond);
                    }
                    return LocalDateTime.of(year, month, day, hour, minute, second);
                }
                return LocalDateTime.of(year, month, day, hour, minute);
            }
            case VALUE_STRING: {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return LocalDateTime.parse(string);
            }
        }
        throw context.wrongTokenException(parser, JsonToken.START_ARRAY, "Expected array or string.");
    }
}

