/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import java.util.Objects;

public class ArrayBlock
extends AbstractArrayBlock {
    private final Block values;
    private final Slice offsets;
    private final int offsetBase;
    private final Slice valueIsNull;

    public ArrayBlock(Block values, Slice offsets, int offsetBase, Slice valueIsNull) {
        this.values = Objects.requireNonNull(values);
        this.offsets = Objects.requireNonNull(offsets);
        this.offsetBase = offsetBase;
        this.valueIsNull = Objects.requireNonNull(valueIsNull);
    }

    @Override
    public int getPositionCount() {
        return this.valueIsNull.length();
    }

    @Override
    protected Block getValues() {
        return this.values;
    }

    @Override
    protected Slice getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return this.offsetBase;
    }

    @Override
    protected Slice getValueIsNull() {
        return this.valueIsNull;
    }

    @Override
    public void assureLoaded() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

