/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import java.security.Principal;

public class AccessDeniedException
extends PrestoException {
    public AccessDeniedException(String message) {
        super((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "Access Denied: " + message);
    }

    public static void denySetUser(Principal principal, String userName) {
        AccessDeniedException.denySetUser(principal, userName, null);
    }

    public static void denySetUser(Principal principal, String userName, String extraInfo) {
        throw new AccessDeniedException(String.format("Principal %s cannot become user %s%s", principal, userName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateTable(String tableName) {
        AccessDeniedException.denyCreateTable(tableName, null);
    }

    public static void denyCreateTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot create table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropTable(String tableName) {
        AccessDeniedException.denyDropTable(tableName, null);
    }

    public static void denyDropTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRenameTable(String tableName, String newTableName) {
        AccessDeniedException.denyRenameTable(tableName, newTableName, null);
    }

    public static void denyRenameTable(String tableName, String newTableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot rename table from %s to %s%s", tableName, newTableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySelectTable(String tableName) {
        AccessDeniedException.denySelectTable(tableName, null);
    }

    public static void denySelectTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot select from table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyInsertTable(String tableName) {
        AccessDeniedException.denyInsertTable(tableName, null);
    }

    public static void denyInsertTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot insert into table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDeleteTable(String tableName) {
        AccessDeniedException.denyDeleteTable(tableName, null);
    }

    public static void denyDeleteTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot delete from table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateView(String viewName) {
        AccessDeniedException.denyCreateView(viewName, null);
    }

    public static void denyCreateView(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot create view %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropView(String viewName) {
        AccessDeniedException.denyDropView(viewName, null);
    }

    public static void denyDropView(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop view %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySelectView(String viewName) {
        AccessDeniedException.denySelectView(viewName, null);
    }

    public static void denySelectView(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot select from view %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetSystemSessionProperty(String propertyName) {
        AccessDeniedException.denySetSystemSessionProperty(propertyName, null);
    }

    public static void denySetSystemSessionProperty(String propertyName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set system session property %s%s", propertyName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetCatalogSessionProperty(String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(catalogName, propertyName, null);
    }

    public static void denySetCatalogSessionProperty(String catalogName, String propertyName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set catalog session property %s.%s%s", catalogName, propertyName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    private static Object formatExtraInfo(String extraInfo) {
        if (extraInfo == null || extraInfo.isEmpty()) {
            return "";
        }
        return ": " + extraInfo;
    }
}

