package com.facebook.presto.jdbc.internal.jackson.datatype.jdk7;

import java.nio.file.Path;

import com.facebook.presto.jdbc.internal.jackson.databind.JsonSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.module.SimpleModule;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.std.ToStringSerializer;

public class Jdk7Module extends SimpleModule
{
    private static final long serialVersionUID = 1L;

    public Jdk7Module()
    {
        super(PackageVersion.VERSION);

        // first deserializers
//        addDeserializer(Paths.class, new PathsDeserializer());

        // then serializers:
        final JsonSerializer<Object> stringSer = ToStringSerializer.instance;
        addSerializer(Path.class, stringSer);
        addDeserializer(Path.class, new PathDeserializer());

        // then key deserializers?
//       addKeyDeserializer(Paths.class, new PathsKeyDeserializer());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }
}
