package com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser.key;

import java.io.IOException;

import com.facebook.presto.jdbc.internal.joda.time.*;

import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;

public class DateTimeKeyDeserializer extends JodaKeyDeserializer {

    @Override
    protected DateTime deserialize(String key, DeserializationContext ctxt) throws IOException, JsonProcessingException{
        return new DateTime(key, DateTimeZone.forTimeZone(ctxt.getTimeZone()));
    }

}
