/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.jdk8;

import com.facebook.presto.jdbc.internal.jackson.databind.BeanDescription;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializationConfig;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.Serializers;
import com.facebook.presto.jdbc.internal.jackson.datatype.jdk8.OptionalDoubleSerializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.jdk8.OptionalIntSerializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.jdk8.OptionalLongSerializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.jdk8.OptionalSerializer;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

class Jdk8Serializers
extends Serializers.Base {
    Jdk8Serializers() {
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> raw = type.getRawClass();
        if (Optional.class.isAssignableFrom(raw)) {
            return new OptionalSerializer(type);
        }
        if (OptionalInt.class.isAssignableFrom(raw)) {
            return OptionalIntSerializer.INSTANCE;
        }
        if (OptionalLong.class.isAssignableFrom(raw)) {
            return OptionalLongSerializer.INSTANCE;
        }
        if (OptionalDouble.class.isAssignableFrom(raw)) {
            return OptionalDoubleSerializer.INSTANCE;
        }
        return super.findSerializer(config, type, beanDesc);
    }
}

