/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.type.Type;

public interface BlockBuilder
extends Block {
    public BlockBuilder writeByte(int var1);

    public BlockBuilder writeShort(int var1);

    public BlockBuilder writeInt(int var1);

    public BlockBuilder writeLong(long var1);

    public BlockBuilder writeFloat(float var1);

    public BlockBuilder writeDouble(double var1);

    public BlockBuilder writeBytes(Slice var1, int var2, int var3);

    default public BlockBuilder writeObject(Object value) {
        throw new UnsupportedOperationException();
    }

    default public BlockBuilder write(Type type, Object value) {
        if (value == null) {
            this.appendNull();
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(this, (Boolean)value);
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(this, ((Number)value).doubleValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(this, ((Number)value).longValue());
        } else if (type.getJavaType() == Slice.class) {
            Slice slice = value instanceof byte[] ? Slices.wrappedBuffer((byte[])value) : (value instanceof String ? Slices.utf8Slice((String)value) : (Slice)value);
            type.writeSlice(this, slice, 0, slice.length());
        } else {
            type.writeObject(this, value);
        }
        return this;
    }

    default public BlockBuilder beginBlockEntry() {
        throw new UnsupportedOperationException();
    }

    public BlockBuilder closeEntry();

    public BlockBuilder appendNull();

    public Block build();
}

