/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.AbstractFixedWidthType;
import com.facebook.presto.jdbc.internal.spi.type.DateTimeEncoding;
import com.facebook.presto.jdbc.internal.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;

public final class TimeWithTimeZoneType
extends AbstractFixedWidthType {
    public static final TimeWithTimeZoneType TIME_WITH_TIME_ZONE = new TimeWithTimeZoneType();

    private TimeWithTimeZoneType() {
        super(TypeSignature.parseTypeSignature("time with time zone"), Long.TYPE, 8);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new SqlTimeWithTimeZone(block.getLong(position, 0));
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long rightValue;
        long leftValue = DateTimeEncoding.unpackMillisUtc(leftBlock.getLong(leftPosition, 0));
        return leftValue == (rightValue = DateTimeEncoding.unpackMillisUtc(rightBlock.getLong(rightPosition, 0)));
    }

    @Override
    public int hash(Block block, int position) {
        long value = DateTimeEncoding.unpackMillisUtc(block.getLong(position, 0));
        return (int)(value ^ value >>> 32);
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftValue = DateTimeEncoding.unpackMillisUtc(leftBlock.getLong(leftPosition, 0));
        long rightValue = DateTimeEncoding.unpackMillisUtc(rightBlock.getLong(rightPosition, 0));
        return Long.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0)).closeEntry();
        }
    }

    @Override
    public long getLong(Block block, int position) {
        return block.getLong(position, 0);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeLong(value).closeEntry();
    }
}

