/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.DynamicSliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockValidationUtil;
import com.facebook.presto.jdbc.internal.spi.block.FixedWidthBlock;
import java.util.List;

public class FixedWidthBlockBuilder
extends AbstractFixedWidthBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FixedWidthBlockBuilder.class).instanceSize() + BlockBuilderStatus.INSTANCE_SIZE;
    private final BlockBuilderStatus blockBuilderStatus;
    private final SliceOutput sliceOutput;
    private final SliceOutput valueIsNull;
    private int positionCount;
    private int currentEntrySize;

    public FixedWidthBlockBuilder(int fixedSize, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        super(fixedSize);
        this.blockBuilderStatus = blockBuilderStatus;
        this.sliceOutput = new DynamicSliceOutput(fixedSize * expectedEntries);
        this.valueIsNull = new DynamicSliceOutput(expectedEntries);
    }

    public FixedWidthBlockBuilder(int fixedSize, int positionCount) {
        super(fixedSize);
        Slice slice = Slices.allocate(fixedSize * positionCount);
        this.blockBuilderStatus = new BlockBuilderStatus();
        this.sliceOutput = slice.getOutput();
        this.valueIsNull = Slices.allocate(positionCount).getOutput();
    }

    @Override
    protected Slice getRawSlice() {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        long size = this.getRawSlice().length() + this.valueIsNull.getUnderlyingSlice().length();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public int getRetainedSizeInBytes() {
        long size = INSTANCE_SIZE + this.getRawSlice().getRetainedSize() + this.valueIsNull.getUnderlyingSlice().getRetainedSize();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockValidationUtil.checkValidPositions(positions, this.positionCount);
        SliceOutput newSlice = Slices.allocate(positions.size() * this.fixedSize).getOutput();
        SliceOutput newValueIsNull = Slices.allocate(positions.size()).getOutput();
        for (int position : positions) {
            newValueIsNull.appendByte(this.valueIsNull.getUnderlyingSlice().getByte(position));
            newSlice.appendBytes(this.getRawSlice().getBytes(position * this.fixedSize, this.fixedSize));
        }
        return new FixedWidthBlock(this.fixedSize, positions.size(), newSlice.slice(), newValueIsNull.slice());
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.sliceOutput.writeByte(value);
        ++this.currentEntrySize;
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.sliceOutput.writeShort(value);
        this.currentEntrySize += 2;
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.sliceOutput.writeInt(value);
        this.currentEntrySize += 4;
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.sliceOutput.writeLong(value);
        this.currentEntrySize += 8;
        return this;
    }

    @Override
    public BlockBuilder writeFloat(float value) {
        this.sliceOutput.writeFloat(value);
        this.currentEntrySize += 4;
        return this;
    }

    @Override
    public BlockBuilder writeDouble(double value) {
        this.sliceOutput.writeDouble(value);
        this.currentEntrySize += 8;
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        this.sliceOutput.writeBytes(source, sourceIndex, length);
        this.currentEntrySize += length;
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.currentEntrySize != this.fixedSize) {
            throw new IllegalStateException("Expected entry size to be exactly " + this.fixedSize + " but was " + this.currentEntrySize);
        }
        this.entryAdded(false);
        this.currentEntrySize = 0;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.sliceOutput.writeZero(this.fixedSize);
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        this.valueIsNull.appendByte(isNull ? 1 : 0);
        ++this.positionCount;
        this.blockBuilderStatus.addBytes(1 + this.fixedSize);
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull.getUnderlyingSlice().getByte(position) != 0;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        Slice newSlice = this.sliceOutput.slice().slice(positionOffset * this.fixedSize, length * this.fixedSize);
        Slice newValueIsNull = this.valueIsNull.slice().slice(positionOffset, length);
        return new FixedWidthBlock(this.fixedSize, length, newSlice, newValueIsNull);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        Slice newSlice = Slices.copyOf(this.sliceOutput.getUnderlyingSlice(), positionOffset * this.fixedSize, length * this.fixedSize);
        Slice newValueIsNull = Slices.copyOf(this.valueIsNull.getUnderlyingSlice(), positionOffset, length);
        return new FixedWidthBlock(this.fixedSize, length, newSlice, newValueIsNull);
    }

    @Override
    public Block build() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return new FixedWidthBlock(this.fixedSize, this.positionCount, this.sliceOutput.slice(), this.valueIsNull.slice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", fixedSize=").append(this.fixedSize);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append('}');
        return sb.toString();
    }
}

