package com.facebook.presto.jdbc.internal.jackson.datatype.jdk8;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

import com.facebook.presto.jdbc.internal.jackson.databind.BeanDescription;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationConfig;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonMappingException;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.Deserializers;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.type.TypeFactory;

class Jdk8Deserializers extends Deserializers.Base
{
    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc)
    throws JsonMappingException
    {
        final Class<?> raw = type.getRawClass();
        if (raw == Optional.class) {
            JavaType[] types = config.getTypeFactory().findTypeParameters(type, Optional.class);
            JavaType refType = (types == null) ? TypeFactory.unknownType() : types[0];
            JsonDeserializer<?> valueDeser = type.getValueHandler();
            TypeDeserializer typeDeser = type.getTypeHandler();
            // [jackson-datatype-guava:Issue#42]: Polymorphic types need type deserializer
            if (typeDeser == null) {
                try {
                    typeDeser = config.findTypeDeserializer(refType);
                } catch (NoSuchMethodError e) { // Running on Jackson 2.3.x, remove this ugly hack once we drop support
                    typeDeser = null;
                }
            }
            return new OptionalDeserializer(type, refType, typeDeser, valueDeser);
        }
        if (raw == OptionalInt.class) {
            return OptionalIntDeserializer.INSTANCE;
        }
        if (raw == OptionalLong.class) {
            return OptionalLongDeserializer.INSTANCE;
        }
        if (raw == OptionalDouble.class) {
            return OptionalDoubleDeserializer.INSTANCE;
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }
}
