/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import com.facebook.presto.jdbc.internal.spi.type.NamedTypeSignature;
import com.facebook.presto.jdbc.internal.spi.type.ParameterKind;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignatureParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TypeSignature {
    private final String base;
    private final List<TypeSignatureParameter> parameters;

    public TypeSignature(String base, List<TypeSignatureParameter> parameters) {
        TypeSignature.checkArgument(base != null, "base is null", new Object[0]);
        this.base = base;
        TypeSignature.checkArgument(!base.isEmpty(), "base is empty", new Object[0]);
        TypeSignature.checkArgument(TypeSignature.validateName(base), "Bad characters in base type: %s", base);
        TypeSignature.checkArgument(parameters != null, "parameters is null", new Object[0]);
        this.parameters = Collections.unmodifiableList(new ArrayList<TypeSignatureParameter>(parameters));
    }

    @Deprecated
    public TypeSignature(String base, List<TypeSignature> typeSignatureParameters, List<String> literalParameters) {
        this(base, TypeSignature.createNamedTypeParameters(typeSignatureParameters, literalParameters));
    }

    public TypeSignature bindParameters(Map<String, Type> boundParameters) {
        if (boundParameters.containsKey(this.base)) {
            if (!this.getParameters().isEmpty()) {
                throw new IllegalStateException("Type parameters cannot have parameters");
            }
            return boundParameters.get(this.base).getTypeSignature();
        }
        List<TypeSignatureParameter> parameters = this.getParameters().stream().map(signature -> signature.bindParameters(boundParameters)).collect(Collectors.toList());
        return new TypeSignature(this.base, parameters);
    }

    public String getBase() {
        return this.base;
    }

    public List<TypeSignatureParameter> getParameters() {
        return this.parameters;
    }

    public List<TypeSignature> getTypeParametersAsTypeSignatures() {
        ArrayList<TypeSignature> result = new ArrayList<TypeSignature>();
        for (TypeSignatureParameter parameter : this.parameters) {
            if (parameter.getKind() != ParameterKind.TYPE_SIGNATURE) {
                throw new IllegalStateException(String.format("Expected all parameters to be TypeSignatures but [%s] was found", parameter.toString()));
            }
            result.add(parameter.getTypeSignature());
        }
        return result;
    }

    @JsonCreator
    public static TypeSignature parseTypeSignature(String signature) {
        if (!signature.contains("<") && !signature.contains("(")) {
            return new TypeSignature(signature, new ArrayList<TypeSignatureParameter>());
        }
        if (signature.startsWith("row")) {
            return TypeSignature.parseRowTypeSignature(signature);
        }
        String baseName = null;
        ArrayList<TypeSignatureParameter> parameters = new ArrayList<TypeSignatureParameter>();
        int parameterStart = -1;
        int bracketCount = 0;
        for (int i = 0; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (c == '(' || c == '<') {
                if (bracketCount == 0) {
                    TypeSignature.verify(baseName == null, "Expected baseName to be null");
                    TypeSignature.verify(parameterStart == -1, "Expected parameter start to be -1");
                    baseName = signature.substring(0, i);
                    parameterStart = i + 1;
                }
                ++bracketCount;
                continue;
            }
            if (c == ')' || c == '>') {
                TypeSignature.checkArgument(--bracketCount >= 0, "Bad type signature: '%s'", signature);
                if (bracketCount != 0) continue;
                TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
                TypeSignature.parseTypeSignatureParameter(signature, parameterStart, i, parameters);
                parameterStart = i + 1;
                if (i != signature.length() - 1) continue;
                return new TypeSignature(baseName, parameters);
            }
            if (c != ',' || bracketCount != 1) continue;
            TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
            TypeSignature.parseTypeSignatureParameter(signature, parameterStart, i, parameters);
            parameterStart = i + 1;
        }
        throw new IllegalArgumentException(String.format("Bad type signature: '%s'", signature));
    }

    @Deprecated
    private static TypeSignature parseRowTypeSignature(String signature) {
        String baseName = null;
        ArrayList<TypeSignature> parameters = new ArrayList<TypeSignature>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        int parameterStart = -1;
        int bracketCount = 0;
        boolean inLiteralParameters = false;
        for (int i = 0; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (c == '<') {
                if (bracketCount == 0) {
                    TypeSignature.verify(baseName == null, "Expected baseName to be null");
                    TypeSignature.verify(parameterStart == -1, "Expected parameter start to be -1");
                    baseName = signature.substring(0, i);
                    parameterStart = i + 1;
                }
                ++bracketCount;
                continue;
            }
            if (c == '>') {
                TypeSignature.checkArgument(--bracketCount >= 0, "Bad type signature: '%s'", signature);
                if (bracketCount != 0) continue;
                TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
                parameters.add(TypeSignature.parseTypeSignature(signature.substring(parameterStart, i)));
                parameterStart = i + 1;
                TypeSignature.verify(i < signature.length() - 1, "Row's signature can not end with angle bracket");
                continue;
            }
            if (c == ',') {
                if (bracketCount != 1) continue;
                if (!inLiteralParameters) {
                    TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
                    parameters.add(TypeSignature.parseTypeSignature(signature.substring(parameterStart, i)));
                    parameterStart = i + 1;
                    continue;
                }
                TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
                fieldNames.add(TypeSignature.parseFieldName(signature.substring(parameterStart, i)));
                parameterStart = i + 1;
                continue;
            }
            if (c == '(') {
                if (bracketCount == 0) {
                    inLiteralParameters = true;
                    if (baseName == null) {
                        TypeSignature.verify(parameters.isEmpty(), "Expected no parameters");
                        TypeSignature.verify(parameterStart == -1, "Expected parameter start to be -1");
                        baseName = signature.substring(0, i);
                    }
                    parameterStart = i + 1;
                }
                ++bracketCount;
                continue;
            }
            if (c != ')' || --bracketCount != 0) continue;
            TypeSignature.checkArgument(inLiteralParameters, "Bad type signature: '%s'", signature);
            inLiteralParameters = false;
            TypeSignature.checkArgument(i == signature.length() - 1, "Bad type signature: '%s'", signature);
            TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
            fieldNames.add(TypeSignature.parseFieldName(signature.substring(parameterStart, i)));
            return new TypeSignature(baseName, TypeSignature.createNamedTypeParameters(parameters, fieldNames));
        }
        throw new IllegalArgumentException(String.format("Bad type signature: '%s'", signature));
    }

    private static List<TypeSignatureParameter> createNamedTypeParameters(List<TypeSignature> parameters, List<String> fieldNames) {
        Objects.requireNonNull(parameters, "parameters is null");
        Objects.requireNonNull(fieldNames, "fieldNames is null");
        TypeSignature.verify(parameters.size() == fieldNames.size() || fieldNames.isEmpty(), "Number of parameters and fieldNames for ROW type doesn't match");
        ArrayList<TypeSignatureParameter> result = new ArrayList<TypeSignatureParameter>();
        for (int i = 0; i < parameters.size(); ++i) {
            String fieldName = fieldNames.isEmpty() ? String.format("field%d", i) : fieldNames.get(i);
            result.add(TypeSignatureParameter.of(new NamedTypeSignature(fieldName, parameters.get(i))));
        }
        return result;
    }

    private static void parseTypeSignatureParameter(String signature, int begin, int end, List<TypeSignatureParameter> parameters) {
        if (Character.isDigit(signature.charAt(begin))) {
            parameters.add(TypeSignatureParameter.of(Long.parseLong(signature.substring(begin, end))));
        } else {
            parameters.add(TypeSignatureParameter.of(TypeSignature.parseTypeSignature(signature.substring(begin, end))));
        }
    }

    private static String parseFieldName(String fieldName) {
        TypeSignature.checkArgument(fieldName != null && fieldName.length() >= 2, "Bad fieldName: '%s'", fieldName);
        TypeSignature.checkArgument(fieldName.startsWith("'") && fieldName.endsWith("'"), "Bad fieldName: '%s'", fieldName);
        return fieldName.substring(1, fieldName.length() - 1);
    }

    @JsonValue
    public String toString() {
        if (this.base.equals("row")) {
            return this.rowToString();
        }
        StringBuilder typeName = new StringBuilder(this.base);
        if (!this.parameters.isEmpty()) {
            typeName.append("(");
            boolean first = true;
            for (TypeSignatureParameter parameter : this.parameters) {
                if (!first) {
                    typeName.append(",");
                }
                first = false;
                typeName.append(parameter.toString());
            }
            typeName.append(")");
        }
        return typeName.toString();
    }

    @Deprecated
    private String rowToString() {
        TypeSignature.verify(this.parameters.stream().allMatch(parameter -> parameter.getKind() == ParameterKind.NAMED_TYPE_SIGNATURE), String.format("Incorrect parameters for row type %s", this.parameters));
        String types = this.parameters.stream().map(TypeSignatureParameter::getNamedTypeSignature).map(NamedTypeSignature::getTypeSignature).map(TypeSignature::toString).collect(Collectors.joining(","));
        String fieldNames = this.parameters.stream().map(TypeSignatureParameter::getNamedTypeSignature).map(NamedTypeSignature::getName).map(name -> String.format("'%s'", name)).collect(Collectors.joining(","));
        return String.format("row<%s>(%s)", types, fieldNames);
    }

    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    private static void verify(boolean argument, String message) {
        if (!argument) {
            throw new AssertionError((Object)message);
        }
    }

    private static boolean validateName(String name) {
        return name.chars().noneMatch(c -> c == 60 || c == 62 || c == 44);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSignature other = (TypeSignature)o;
        return Objects.equals(this.base.toLowerCase(Locale.ENGLISH), other.base.toLowerCase(Locale.ENGLISH)) && Objects.equals(this.parameters, other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.base.toLowerCase(Locale.ENGLISH), this.parameters);
    }
}

