/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.AuthenticationProtocolHandler;
import com.facebook.presto.jdbc.internal.jetty.client.HttpClient;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.ProxyConfiguration;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.client.api.Response;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import java.net.URI;

public class ProxyAuthenticationProtocolHandler
extends AuthenticationProtocolHandler {
    public static final String NAME = "proxy-authenticate";

    public ProxyAuthenticationProtocolHandler(HttpClient client) {
        this(client, 16384);
    }

    public ProxyAuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        super(client, maxContentLength);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return response.getStatus() == 407;
    }

    @Override
    protected HttpHeader getAuthenticateHeader() {
        return HttpHeader.PROXY_AUTHENTICATE;
    }

    @Override
    protected HttpHeader getAuthorizationHeader() {
        return HttpHeader.PROXY_AUTHORIZATION;
    }

    @Override
    protected URI getAuthenticationURI(Request request) {
        HttpDestination destination = this.getHttpClient().destinationFor(request.getScheme(), request.getHost(), request.getPort());
        ProxyConfiguration.Proxy proxy = destination.getProxy();
        return proxy != null ? proxy.getURI() : request.getURI();
    }
}

