/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.HttpClient;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpResponseException;
import com.facebook.presto.jdbc.internal.jetty.client.Origin;
import com.facebook.presto.jdbc.internal.jetty.client.ProxyConfiguration;
import com.facebook.presto.jdbc.internal.jetty.client.api.Connection;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.client.api.Response;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpConnectionOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.http.HttpMethod;
import com.facebook.presto.jdbc.internal.jetty.http.HttpScheme;
import com.facebook.presto.jdbc.internal.jetty.io.ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.ssl.SslClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.util.Promise;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import com.facebook.presto.jdbc.internal.jetty.util.ssl.SslContextFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpProxy
extends ProxyConfiguration.Proxy {
    public HttpProxy(String host, int port) {
        this(new Origin.Address(host, port), false);
    }

    public HttpProxy(Origin.Address address, boolean secure) {
        super(address, secure);
    }

    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new HttpProxyClientConnectionFactory(connectionFactory);
    }

    @Override
    public URI getURI() {
        String scheme = this.isSecure() ? HttpScheme.HTTPS.asString() : HttpScheme.HTTP.asString();
        return URI.create(new Origin(scheme, this.getAddress()).asString());
    }

    public static class HttpProxyClientConnectionFactory
    implements ClientConnectionFactory {
        private static final Logger LOG = Log.getLogger(HttpProxyClientConnectionFactory.class);
        private final ClientConnectionFactory connectionFactory;

        public HttpProxyClientConnectionFactory(ClientConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        @Override
        public com.facebook.presto.jdbc.internal.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            Promise promise = (Promise)context.get("http.connection.promise");
            ProxyPromise proxyPromise = new ProxyPromise(endPoint, promise, context);
            context.put("http.connection.promise", proxyPromise);
            return this.connectionFactory.newConnection(endPoint, context);
        }

        private class ProxyPromise
        implements Promise<Connection> {
            private final EndPoint endPoint;
            private final Promise<Connection> promise;
            private final Map<String, Object> context;

            private ProxyPromise(EndPoint endPoint, Promise<Connection> promise, Map<String, Object> context) {
                this.endPoint = endPoint;
                this.promise = promise;
                this.context = context;
            }

            @Override
            public void succeeded(Connection connection) {
                HttpDestination destination = (HttpDestination)this.context.get("http.destination");
                if (HttpScheme.HTTPS.is(destination.getScheme())) {
                    SslContextFactory sslContextFactory = destination.getHttpClient().getSslContextFactory();
                    if (sslContextFactory != null) {
                        this.tunnel(destination, connection);
                    } else {
                        String message = String.format("Cannot perform requests over SSL, no %s in %s", SslContextFactory.class.getSimpleName(), HttpClient.class.getSimpleName());
                        this.tunnelFailed(new IllegalStateException(message));
                    }
                } else {
                    this.promise.succeeded(connection);
                }
            }

            @Override
            public void failed(Throwable x) {
                this.tunnelFailed(x);
            }

            private void tunnel(HttpDestination destination, Connection connection) {
                String target = destination.getOrigin().getAddress().asString();
                Origin.Address proxyAddress = destination.getConnectAddress();
                HttpClient httpClient = destination.getHttpClient();
                long connectTimeout = httpClient.getConnectTimeout();
                Request connect = httpClient.newRequest(proxyAddress.getHost(), proxyAddress.getPort()).scheme(HttpScheme.HTTP.asString()).method(HttpMethod.CONNECT).path(target).header(HttpHeader.HOST, target).idleTimeout(2L * connectTimeout, TimeUnit.MILLISECONDS).timeout(connectTimeout, TimeUnit.MILLISECONDS);
                connection.send(connect, result -> {
                    if (result.isFailed()) {
                        this.tunnelFailed(result.getFailure());
                    } else {
                        Response response = result.getResponse();
                        if (response.getStatus() == 200) {
                            this.tunnelSucceeded();
                        } else {
                            this.tunnelFailed(new HttpResponseException("Received " + response + " for " + result.getRequest(), response));
                        }
                    }
                });
            }

            private void tunnelSucceeded() {
                try {
                    this.context.put("http.connection.promise", this.promise);
                    HttpDestination destination = (HttpDestination)this.context.get("http.destination");
                    HttpClient client = destination.getHttpClient();
                    SslClientConnectionFactory sslConnectionFactory = new SslClientConnectionFactory(client.getSslContextFactory(), client.getByteBufferPool(), client.getExecutor(), HttpProxyClientConnectionFactory.this.connectionFactory);
                    HttpConnectionOverHTTP oldConnection = (HttpConnectionOverHTTP)this.endPoint.getConnection();
                    com.facebook.presto.jdbc.internal.jetty.io.Connection newConnection = sslConnectionFactory.newConnection(this.endPoint, this.context);
                    this.endPoint.upgrade(newConnection);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HTTP tunnel established: {} over {}", oldConnection, newConnection);
                    }
                }
                catch (Throwable x) {
                    this.tunnelFailed(x);
                }
            }

            private void tunnelFailed(Throwable failure) {
                this.endPoint.close();
                this.promise.failed(failure);
            }
        }
    }
}

