/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.util.thread.strategy;

import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import com.facebook.presto.jdbc.internal.jetty.util.thread.ExecutionStrategy;
import java.util.concurrent.Executor;

public class ProduceExecuteConsume
implements ExecutionStrategy {
    private static final Logger LOG = Log.getLogger(ExecutionStrategy.class);
    private final ExecutionStrategy.Producer _producer;
    private final Executor _executor;

    public ProduceExecuteConsume(ExecutionStrategy.Producer producer, Executor executor) {
        this._producer = producer;
        this._executor = executor;
    }

    @Override
    public void execute() {
        while (true) {
            Runnable task = this._producer.produce();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} PER produced {}", this._producer, task);
            }
            if (task == null) break;
            this._executor.execute(task);
        }
    }

    @Override
    public void dispatch() {
        this.execute();
    }
}

