/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.spnego;

import com.facebook.presto.jdbc.internal.airlift.http.client.spnego.UriUtil;
import com.facebook.presto.jdbc.internal.airlift.log.Logger;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.base.Throwables;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;
import com.facebook.presto.jdbc.internal.jetty.client.api.Authentication;
import com.facebook.presto.jdbc.internal.jetty.client.api.ContentResponse;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.util.Attributes;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoAuthentication
implements Authentication {
    private static final String NEGOTIATE = HttpHeader.NEGOTIATE.asString();
    private static final Logger LOG = Logger.get(SpnegoAuthentication.class);
    private static final Duration MIN_CREDENTIAL_LIFE_TIME = new Duration(60.0, TimeUnit.SECONDS);
    private static final GSSManager GSS_MANAGER = GSSManager.getInstance();
    private static final Oid SPNEGO_OID;
    private static final Oid KERBEROS_OID;
    private final File keytab;
    private final File credentialCache;
    private final String principal;
    private final String remoteServiceName;
    @GuardedBy(value="this")
    private Session clientSession;

    public SpnegoAuthentication(File keytab, File kerberosConfig, File credentialCache, String principal, String remoteServiceName) {
        Objects.requireNonNull(kerberosConfig, "kerberosConfig is null");
        Objects.requireNonNull(remoteServiceName, "remoteServiceName is null");
        this.keytab = keytab;
        this.credentialCache = credentialCache;
        this.principal = principal;
        this.remoteServiceName = remoteServiceName;
        System.setProperty("java.security.krb5.conf", kerberosConfig.getAbsolutePath());
    }

    @Override
    public Authentication.Result authenticate(Request request, ContentResponse response, final Authentication.HeaderInfo headerInfo, Attributes attributes) {
        final URI normalizedUri = UriUtil.normalizedUri(request.getURI());
        return new Authentication.Result(){

            @Override
            public URI getURI() {
                return normalizedUri;
            }

            @Override
            public void apply(Request request) {
                block12: {
                    GSSContext context = null;
                    try {
                        String servicePrincipal = SpnegoAuthentication.makeServicePrincipal(SpnegoAuthentication.this.remoteServiceName, normalizedUri.getHost());
                        Session session = SpnegoAuthentication.this.getSession();
                        context = (GSSContext)SpnegoAuthentication.doAs(session.getLoginContext().getSubject(), () -> {
                            GSSContext result = GSS_MANAGER.createContext(GSS_MANAGER.createName(servicePrincipal, GSSName.NT_HOSTBASED_SERVICE), SPNEGO_OID, session.getClientCredential(), Integer.MAX_VALUE);
                            result.requestMutualAuth(true);
                            result.requestConf(true);
                            result.requestInteg(true);
                            result.requestCredDeleg(false);
                            return result;
                        });
                        byte[] token = context.initSecContext(new byte[0], 0, 0);
                        if (token != null) {
                            request.header(headerInfo.getHeader(), String.format("%s %s", NEGOTIATE, Base64.getEncoder().encodeToString(token)));
                            break block12;
                        }
                        throw new RuntimeException(String.format("No token generated from GSS context for %s", request.getURI()));
                    }
                    catch (GSSException e) {
                        throw new RuntimeException(String.format("Failed to establish GSSContext for request %s", request.getURI()), e);
                    }
                    catch (LoginException e) {
                        throw new RuntimeException(String.format("Failed to establish LoginContext for request %s", request.getURI()), e);
                    }
                    finally {
                        try {
                            if (context != null) {
                                context.dispose();
                            }
                        }
                        catch (GSSException gSSException) {}
                    }
                }
            }
        };
    }

    @Override
    public boolean matches(String type, URI uri, String realm) {
        return NEGOTIATE.equalsIgnoreCase(type);
    }

    private synchronized Session getSession() throws LoginException, GSSException {
        if (this.clientSession == null || (double)this.clientSession.getClientCredential().getRemainingLifetime() < MIN_CREDENTIAL_LIFE_TIME.getValue(TimeUnit.SECONDS)) {
            LoginContext loginContext = new LoginContext("", null, null, new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    ImmutableMap.Builder<String, String> optionsBuilder = ImmutableMap.builder();
                    optionsBuilder.put("refreshKrb5Config", "true");
                    optionsBuilder.put("doNotPrompt", "true");
                    optionsBuilder.put("useKeyTab", "true");
                    if (LOG.isDebugEnabled()) {
                        optionsBuilder.put("debug", "true");
                    }
                    if (SpnegoAuthentication.this.keytab != null) {
                        optionsBuilder.put("keytab", SpnegoAuthentication.this.keytab.getAbsolutePath());
                    }
                    if (SpnegoAuthentication.this.credentialCache != null) {
                        optionsBuilder.put("ticketCache", SpnegoAuthentication.this.credentialCache.getAbsolutePath());
                        optionsBuilder.put("useTicketCache", "true");
                        optionsBuilder.put("renewTGT", "true");
                    }
                    if (SpnegoAuthentication.this.principal != null) {
                        optionsBuilder.put("principal", SpnegoAuthentication.this.principal);
                    }
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, optionsBuilder.build())};
                }
            });
            loginContext.login();
            Subject subject = loginContext.getSubject();
            Principal clientPrincipal = subject.getPrincipals().iterator().next();
            GSSCredential clientCredential = SpnegoAuthentication.doAs(subject, () -> GSS_MANAGER.createCredential(GSS_MANAGER.createName(clientPrincipal.getName(), GSSName.NT_USER_NAME), 0, KERBEROS_OID, 1));
            this.clientSession = new Session(loginContext, clientCredential);
        }
        return this.clientSession;
    }

    private static String makeServicePrincipal(String serviceName, String hostName) {
        try {
            InetAddress address = InetAddress.getByName(hostName);
            String fullHostName = "localhost".equalsIgnoreCase(address.getHostName()) ? InetAddress.getLocalHost().getCanonicalHostName() : address.getCanonicalHostName();
            Preconditions.checkState(!fullHostName.equalsIgnoreCase("localhost"), "Fully qualified name of localhost should not resolve to 'localhost'. System configuration error?");
            return String.format("%s@%s", serviceName, fullHostName.toLowerCase(Locale.US));
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate(e);
        }
    }

    private static <T> T doAs(Subject subject, GssSupplier<T> action) {
        return (T)Subject.doAs(subject, () -> {
            try {
                return action.get();
            }
            catch (GSSException e) {
                throw Throwables.propagate(e);
            }
        });
    }

    static {
        try {
            SPNEGO_OID = new Oid("1.3.6.1.5.5.2");
            KERBEROS_OID = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class Session {
        private final LoginContext loginContext;
        private final GSSCredential clientCredential;

        public Session(LoginContext loginContext, GSSCredential clientCredential) throws LoginException {
            Objects.requireNonNull(loginContext, "loginContext is null");
            Objects.requireNonNull(clientCredential, "gssCredential is null");
            this.loginContext = loginContext;
            this.clientCredential = clientCredential;
        }

        public LoginContext getLoginContext() {
            return this.loginContext;
        }

        public GSSCredential getClientCredential() {
            return this.clientCredential;
        }
    }

    private static interface GssSupplier<T> {
        public T get() throws GSSException;
    }
}

