/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.Page;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.PageBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.type.FixedWidthType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class PageBuilder {
    private final BlockBuilder[] blockBuilders;
    private final List<Type> types;
    private final int initialExpectedEntries;
    private PageBuilderStatus pageBuilderStatus;
    private int declaredPositions;

    public PageBuilder(List<? extends Type> types) {
        this(Integer.MAX_VALUE, types);
    }

    public PageBuilder(int initialExpectedEntries, List<? extends Type> types) {
        int maxBlockSizeInBytes;
        this.types = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(types, "types is null")));
        if (!types.isEmpty()) {
            maxBlockSizeInBytes = (int)(1048576.0 / (double)types.size());
            maxBlockSizeInBytes = Math.min(65536, maxBlockSizeInBytes);
        } else {
            maxBlockSizeInBytes = 0;
        }
        this.pageBuilderStatus = new PageBuilderStatus(0x100000, maxBlockSizeInBytes);
        int expectedEntries = Math.min(maxBlockSizeInBytes, initialExpectedEntries);
        for (Type type : types) {
            if (type instanceof FixedWidthType) {
                int fixedSize = Math.max(((FixedWidthType)type).getFixedSize(), 1);
                expectedEntries = Math.min(expectedEntries, maxBlockSizeInBytes / fixedSize);
                continue;
            }
            expectedEntries = Math.min(expectedEntries, maxBlockSizeInBytes / 32);
        }
        this.blockBuilders = new BlockBuilder[types.size()];
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            this.blockBuilders[i] = types.get(i).createBlockBuilder(this.pageBuilderStatus.createBlockBuilderStatus(), expectedEntries, this.pageBuilderStatus.getMaxBlockSizeInBytes() / expectedEntries);
        }
        this.initialExpectedEntries = expectedEntries;
    }

    public void reset() {
        if (this.isEmpty()) {
            return;
        }
        this.pageBuilderStatus = new PageBuilderStatus(this.pageBuilderStatus.getMaxPageSizeInBytes(), this.pageBuilderStatus.getMaxBlockSizeInBytes());
        int expectedEntries = this.declaredPositions > 0 ? this.declaredPositions : this.initialExpectedEntries;
        this.declaredPositions = 0;
        for (int i = 0; i < this.types.size(); ++i) {
            int expectedEntrySize = (int)Math.ceil((double)this.blockBuilders[i].getSizeInBytes() / (double)expectedEntries);
            this.blockBuilders[i] = this.types.get(i).createBlockBuilder(this.pageBuilderStatus.createBlockBuilderStatus(), expectedEntries, expectedEntrySize);
        }
    }

    public Type getType(int channel) {
        return this.types.get(channel);
    }

    public BlockBuilder getBlockBuilder(int channel) {
        return this.blockBuilders[channel];
    }

    public void declarePosition() {
        ++this.declaredPositions;
    }

    public void declarePositions(int positions) {
        this.declaredPositions = positions;
    }

    public boolean isFull() {
        return this.declaredPositions == Integer.MAX_VALUE || this.pageBuilderStatus.isFull();
    }

    public boolean isEmpty() {
        return this.declaredPositions == 0;
    }

    public int getPositionCount() {
        return this.declaredPositions;
    }

    public long getSizeInBytes() {
        return this.pageBuilderStatus.getSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        return Stream.of(this.blockBuilders).mapToLong(Block::getRetainedSizeInBytes).sum();
    }

    public Page build() {
        if (this.blockBuilders.length == 0) {
            return new Page(this.declaredPositions, new Block[0]);
        }
        Block[] blocks = new Block[this.blockBuilders.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.blockBuilders[i].build();
            if (blocks[i].getPositionCount() == this.declaredPositions) continue;
            throw new IllegalStateException(String.format("Declared positions (%s) does not match block %s's number of entries (%s)", this.declaredPositions, i, blocks[i].getPositionCount()));
        }
        return new Page(blocks);
    }
}

