/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockValidationUtil;
import com.facebook.presto.jdbc.internal.spi.block.FixedWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.LazyBlockLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class LazyFixedWidthBlock
extends AbstractFixedWidthBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LazyFixedWidthBlock.class).instanceSize();
    private final int positionCount;
    private LazyBlockLoader<LazyFixedWidthBlock> loader;
    private Slice slice;
    private boolean[] valueIsNull;

    public LazyFixedWidthBlock(int fixedSize, int positionCount, LazyBlockLoader<LazyFixedWidthBlock> loader) {
        super(fixedSize);
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.loader = Objects.requireNonNull(loader);
    }

    LazyFixedWidthBlock(int fixedSize, int positionCount, LazyBlockLoader<LazyFixedWidthBlock> loader, Slice slice, boolean[] valueIsNull) {
        super(fixedSize);
        this.positionCount = positionCount;
        this.loader = loader;
        this.slice = slice;
        this.valueIsNull = valueIsNull;
    }

    @Override
    protected Slice getRawSlice() {
        this.assureLoaded();
        return this.slice;
    }

    @Override
    protected boolean isEntryNull(int position) {
        this.assureLoaded();
        return this.valueIsNull[position];
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        long size = (long)(this.positionCount * this.fixedSize) + SizeOf.sizeOf(this.valueIsNull);
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public int getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + SizeOf.sizeOf(this.valueIsNull);
        if (this.slice != null) {
            size += (long)this.slice.getRetainedSize();
        }
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockValidationUtil.checkValidPositions(positions, this.positionCount);
        this.assureLoaded();
        SliceOutput newSlice = Slices.allocate(positions.size() * this.fixedSize).getOutput();
        SliceOutput newValueIsNull = Slices.allocate(positions.size()).getOutput();
        for (int position : positions) {
            newValueIsNull.appendByte(this.valueIsNull[position] ? 1 : 0);
            newSlice.appendBytes(this.getRawSlice().getBytes(position * this.fixedSize, this.fixedSize));
        }
        return new FixedWidthBlock(this.fixedSize, positions.size(), newSlice.slice(), newValueIsNull.slice());
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + this.positionCount + " positions");
        }
        this.assureLoaded();
        Slice newSlice = this.slice.slice(positionOffset * this.fixedSize, length * this.fixedSize);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        return new FixedWidthBlock(this.fixedSize, length, newSlice, Slices.wrappedBooleanArray(newValueIsNull));
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + this.positionCount + " positions");
        }
        this.assureLoaded();
        Slice newSlice = Slices.copyOf(this.slice, positionOffset * this.fixedSize, length * this.fixedSize);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        return new FixedWidthBlock(this.fixedSize, length, newSlice, Slices.wrappedBooleanArray(newValueIsNull));
    }

    @Override
    public void assureLoaded() {
        if (this.slice != null) {
            return;
        }
        this.loader.load(this);
        if (this.slice == null) {
            throw new IllegalArgumentException("Lazy block loader did not load this block");
        }
        this.loader = null;
    }

    public void setRawSlice(Slice slice) {
        if (slice.length() < this.positionCount * this.fixedSize) {
            throw new IllegalArgumentException("slice is not large enough to hold all positions");
        }
        this.slice = slice;
    }

    public void setNullVector(boolean[] valueIsNull) {
        if (valueIsNull.length < this.positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlock{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", slice=").append(this.slice == null ? "not loaded" : this.slice);
        sb.append('}');
        return sb.toString();
    }
}

