package com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser;

import java.io.IOException;

import com.facebook.presto.jdbc.internal.joda.time.Period;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;

public class PeriodDeserializer
    extends JodaDeserializerBase<Period>
{
    private static final long serialVersionUID = 1L;

    public PeriodDeserializer() { super(Period.class); }
   
    @Override
    public Period deserialize(JsonParser jp, DeserializationContext ctxt)
            throws IOException, JsonProcessingException
    {
        // TODO: perhaps support array of numbers...
        //if (jp.isExpectedStartArrayToken()) { ]
        switch (jp.getCurrentToken()) {
        case VALUE_NUMBER_INT: // assume it's millisecond count
            return new Period(jp.getLongValue());            
        case VALUE_STRING:
            return new Period(jp.getText());
        default:
        }
        throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected JSON Number or String");
   }
}
