/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IntervalYearMonth {
    private static final String LONG_MIN_VALUE = "-768614336404564650-8";
    private static final Pattern FORMAT = Pattern.compile("(\\d+)-(\\d+)");

    private IntervalYearMonth() {
    }

    public static long toMonths(long year, long months) {
        try {
            return Math.addExact(Math.multiplyExact(year, 12L), months);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String formatMonths(long months) {
        if (months == Long.MIN_VALUE) {
            return LONG_MIN_VALUE;
        }
        String sign = "";
        if (months < 0L) {
            sign = "-";
            months = -months;
        }
        return String.format("%s%d-%d", sign, months / 12L, months % 12L);
    }

    public static long parseMonths(String value) {
        Matcher matcher;
        if (value.equals(LONG_MIN_VALUE)) {
            return Long.MIN_VALUE;
        }
        long signum = 1L;
        if (value.startsWith("-")) {
            signum = -1L;
            value = value.substring(1);
        }
        if (!(matcher = FORMAT.matcher(value)).matches()) {
            throw new IllegalArgumentException("Invalid year-month interval: " + value);
        }
        long years = Long.parseLong(matcher.group(1));
        long months = Long.parseLong(matcher.group(2));
        return IntervalYearMonth.toMonths(years, months) * signum;
    }
}

