/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Objects;

public final class SqlVarbinary
implements Comparable<SqlVarbinary> {
    private final byte[] bytes;

    public SqlVarbinary(byte[] bytes) {
        this.bytes = Objects.requireNonNull(bytes, "bytes is null");
    }

    @Override
    public int compareTo(SqlVarbinary obj) {
        for (int i = 0; i < Math.min(this.bytes.length, obj.bytes.length); ++i) {
            if (this.bytes[i] < obj.bytes[i]) {
                return -1;
            }
            if (this.bytes[i] <= obj.bytes[i]) continue;
            return 1;
        }
        return this.bytes.length - obj.bytes.length;
    }

    @JsonValue
    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlVarbinary other = (SqlVarbinary)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }
}

