/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.concurrent;

import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.ForwardingBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class BoundedThreadPool {
    private static final Duration DEFAULT_KEEP_ALIVE = new Duration(60.0, TimeUnit.SECONDS);

    private BoundedThreadPool() {
    }

    public static ThreadPoolExecutor newBoundedThreadPool(int maxThreads, ThreadFactory threadFactory) {
        return BoundedThreadPool.newBoundedThreadPool(0, maxThreads, threadFactory);
    }

    public static ThreadPoolExecutor newBoundedThreadPool(int minThreads, int maxThreads, ThreadFactory threadFactory) {
        return BoundedThreadPool.newBoundedThreadPool(minThreads, maxThreads, threadFactory, DEFAULT_KEEP_ALIVE);
    }

    public static ThreadPoolExecutor newBoundedThreadPool(int minThreads, int maxThreads, ThreadFactory threadFactory, Duration keepAlive) {
        RefusingQueue<Runnable> queue = new RefusingQueue<Runnable>();
        return new ThreadPoolExecutor(minThreads, maxThreads, keepAlive.toMillis(), TimeUnit.MILLISECONDS, queue, threadFactory, (runnable, executor) -> queue.add(runnable));
    }

    private static class RefusingQueue<T>
    extends ForwardingBlockingQueue<T> {
        private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();

        private RefusingQueue() {
        }

        @Override
        protected BlockingQueue<T> delegate() {
            return this.queue;
        }

        @Override
        public boolean offer(T o) {
            return false;
        }
    }
}

