/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import java.util.List;

public abstract class AbstractArrayElementBlock
implements Block {
    protected final int start;

    protected AbstractArrayElementBlock(int start) {
        this.start = start;
    }

    protected abstract BlockBuilder getBlock();

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    @Override
    public int getLength(int position) {
        this.checkReadablePosition(position);
        return this.getBlock().getLength(position + this.start);
    }

    @Override
    public byte getByte(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getBlock().getByte(position + this.start, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getBlock().getShort(position + this.start, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getBlock().getInt(position + this.start, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getBlock().getLong(position + this.start, offset);
    }

    @Override
    public float getFloat(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getBlock().getFloat(position + this.start, offset);
    }

    @Override
    public double getDouble(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getBlock().getDouble(position + this.start, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return this.getBlock().getSlice(position + this.start, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        this.checkReadablePosition(position);
        return this.getBlock().getObject(position + this.start, clazz);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        this.checkReadablePosition(position);
        return this.getBlock().bytesEqual(position + this.start, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        return this.getBlock().bytesCompare(position + this.start, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        this.getBlock().writeBytesTo(position + this.start, offset, length, blockBuilder);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        this.getBlock().writePositionTo(position + this.start, blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        this.checkReadablePosition(position);
        return this.getBlock().equals(position + this.start, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return this.getBlock().hash(position + this.start, offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        this.checkReadablePosition(leftPosition);
        return this.getBlock().compareTo(leftPosition + this.start, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        return this.getBlock().getSingleValueBlock(position + this.start);
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.getBlock().isNull(position + this.start);
    }

    @Override
    public void assureLoaded() {
    }

    @Override
    public BlockEncoding getEncoding() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block getRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }
}

