/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import com.facebook.presto.jdbc.internal.spi.type.Decimals;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;

public final class SqlDecimal {
    private final BigInteger unscaledValue;
    private final int precision;
    private final int scale;

    public SqlDecimal(BigInteger unscaledValue, int precision, int scale) {
        this.unscaledValue = unscaledValue;
        this.precision = precision;
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlDecimal that = (SqlDecimal)o;
        return Objects.equals(this.unscaledValue, that.unscaledValue);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int hashCode() {
        return Objects.hash(this.unscaledValue);
    }

    @JsonValue
    public String toString() {
        return Decimals.toString(this.unscaledValue, this.scale);
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.unscaledValue, this.scale, new MathContext(this.precision));
    }
}

