/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.HttpRequestFilter;
import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.tracetoken.TraceTokenManager;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.google.inject.Inject;

public class TraceTokenRequestFilter
implements HttpRequestFilter {
    public static final String TRACETOKEN_HEADER = "X-Airlift-Tracetoken";
    private final TraceTokenManager traceTokenManager;

    @Inject
    public TraceTokenRequestFilter(TraceTokenManager traceTokenManager) {
        this.traceTokenManager = Preconditions.checkNotNull(traceTokenManager, "traceTokenManager is null");
    }

    @Override
    public Request filterRequest(Request request) {
        Preconditions.checkNotNull(request, "request is null");
        String token = this.traceTokenManager.getCurrentRequestToken();
        if (token == null) {
            return request;
        }
        return Request.Builder.fromRequest(request).addHeader(TRACETOKEN_HEADER, token).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TraceTokenRequestFilter o = (TraceTokenRequestFilter)obj;
        return this.traceTokenManager.equals(o.traceTokenManager);
    }

    public int hashCode() {
        return this.traceTokenManager.hashCode();
    }
}

