/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.generator;

import com.facebook.presto.jdbc.internal.jetty.http2.frames.DataFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.FrameType;
import com.facebook.presto.jdbc.internal.jetty.http2.generator.HeaderGenerator;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import java.nio.ByteBuffer;

public class DataGenerator {
    private final HeaderGenerator headerGenerator;

    public DataGenerator(HeaderGenerator headerGenerator) {
        this.headerGenerator = headerGenerator;
    }

    public void generate(ByteBufferPool.Lease lease, DataFrame frame, int maxLength) {
        this.generateData(lease, frame.getStreamId(), frame.getData(), frame.isEndStream(), maxLength);
    }

    public void generateData(ByteBufferPool.Lease lease, int streamId, ByteBuffer data, boolean last, int maxLength) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int dataLength = data.remaining();
        int maxFrameSize = this.headerGenerator.getMaxFrameSize();
        if (dataLength <= maxLength && dataLength <= maxFrameSize) {
            this.generateFrame(lease, streamId, data, last);
            return;
        }
        int length = Math.min(maxLength, dataLength);
        int frames = length / maxFrameSize;
        if (frames * maxFrameSize != length) {
            ++frames;
        }
        int begin = data.position();
        int end = data.limit();
        for (int i = 1; i <= frames; ++i) {
            int limit = begin + Math.min(maxFrameSize * i, length);
            data.limit(limit);
            ByteBuffer slice = data.slice();
            data.position(limit);
            this.generateFrame(lease, streamId, slice, i == frames && last && limit == end);
        }
        data.limit(end);
    }

    private void generateFrame(ByteBufferPool.Lease lease, int streamId, ByteBuffer data, boolean last) {
        int length = data.remaining();
        int flags = 0;
        if (last) {
            flags |= 1;
        }
        ByteBuffer header = this.headerGenerator.generate(lease, FrameType.DATA, 9 + length, length, flags, streamId);
        BufferUtil.flipToFlush(header, 0);
        lease.append(header, true);
        lease.append(data, false);
    }
}

