/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.ErrorCode;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;

public enum StandardErrorCode implements ErrorCodeSupplier
{
    USER_ERROR(0),
    SYNTAX_ERROR(1),
    ABANDONED_QUERY(2),
    USER_CANCELED(3),
    PERMISSION_DENIED(4),
    NOT_FOUND(5),
    FUNCTION_NOT_FOUND(6),
    INVALID_FUNCTION_ARGUMENT(7),
    DIVISION_BY_ZERO(8),
    INVALID_CAST_ARGUMENT(9),
    OPERATOR_NOT_FOUND(10),
    INVALID_VIEW(11),
    ALREADY_EXISTS(12),
    NOT_SUPPORTED(13),
    INVALID_SESSION_PROPERTY(14),
    INVALID_WINDOW_FRAME(15),
    CONSTRAINT_VIOLATION(16),
    TRANSACTION_CONFLICT(17),
    INVALID_TABLE_PROPERTY(18),
    NUMERIC_VALUE_OUT_OF_RANGE(19),
    UNKNOWN_TRANSACTION(20),
    NOT_IN_TRANSACTION(21),
    TRANSACTION_ALREADY_ABORTED(22),
    READ_ONLY_VIOLATION(23),
    MULTI_CATALOG_WRITE_CONFLICT(24),
    AUTOCOMMIT_WRITE_CONFLICT(25),
    UNSUPPORTED_ISOLATION_LEVEL(26),
    INCOMPATIBLE_CLIENT(27),
    SUBQUERY_MULTIPLE_ROWS(28),
    PROCEDURE_NOT_FOUND(29),
    INVALID_PROCEDURE_ARGUMENT(30),
    QUERY_REJECTED(31),
    AMBIGUOUS_FUNCTION_CALL(32),
    INTERNAL_ERROR(65536),
    TOO_MANY_REQUESTS_FAILED(65537),
    PAGE_TOO_LARGE(65538),
    PAGE_TRANSPORT_ERROR(65539),
    PAGE_TRANSPORT_TIMEOUT(65540),
    NO_NODES_AVAILABLE(65541),
    REMOTE_TASK_ERROR(65542),
    COMPILER_ERROR(65543),
    REMOTE_TASK_MISMATCH(65544),
    SERVER_SHUTTING_DOWN(65545),
    FUNCTION_IMPLEMENTATION_MISSING(65546),
    REMOTE_BUFFER_CLOSE_FAILED(65547),
    SERVER_STARTING_UP(65548),
    FUNCTION_IMPLEMENTATION_ERROR(65549),
    INVALID_PROCEDURE_DEFINITION(65550),
    PROCEDURE_CALL_FAILED(65551),
    AMBIGUOUS_FUNCTION_IMPLEMENTATION(65552),
    ABANDONED_TASK(65553),
    INSUFFICIENT_RESOURCES(131072),
    EXCEEDED_MEMORY_LIMIT(131073),
    QUERY_QUEUE_FULL(131074),
    EXCEEDED_TIME_LIMIT(131075),
    CLUSTER_OUT_OF_MEMORY(131076),
    EXCEEDED_CPU_LIMIT(131077),
    EXTERNAL(0x1000000);

    private final ErrorCode errorCode;

    private StandardErrorCode(int code) {
        this.errorCode = new ErrorCode(code, this.name());
    }

    @Override
    public ErrorCode toErrorCode() {
        return this.errorCode;
    }

    public static ErrorType toErrorType(int code) {
        if (code < INTERNAL_ERROR.toErrorCode().getCode()) {
            return ErrorType.USER_ERROR;
        }
        if (code < INSUFFICIENT_RESOURCES.toErrorCode().getCode()) {
            return ErrorType.INTERNAL_ERROR;
        }
        if (code < EXTERNAL.toErrorCode().getCode()) {
            return ErrorType.INSUFFICIENT_RESOURCES;
        }
        return ErrorType.EXTERNAL;
    }

    public static enum ErrorType {
        USER_ERROR,
        INTERNAL_ERROR,
        INSUFFICIENT_RESOURCES,
        EXTERNAL;

    }
}

