/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.HeaderName;
import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.guava.base.MoreObjects;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import java.util.List;

@Beta
public class UnexpectedResponseException
extends RuntimeException {
    private final Request request;
    private final int statusCode;
    private final String statusMessage;
    private final ListMultimap<HeaderName, String> headers;

    public UnexpectedResponseException(Request request, Response response) {
        this(String.format("%d: %s", response.getStatusCode(), response.getStatusMessage()), request, response.getStatusCode(), response.getStatusMessage(), ImmutableListMultimap.copyOf(response.getHeaders()));
    }

    public UnexpectedResponseException(String message, Request request, Response response) {
        this(message, request, response.getStatusCode(), response.getStatusMessage(), ImmutableListMultimap.copyOf(response.getHeaders()));
    }

    public UnexpectedResponseException(String message, Request request, int statusCode, String statusMessage, ListMultimap<HeaderName, String> headers) {
        super(message);
        this.request = request;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = ImmutableListMultimap.copyOf(headers);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getHeader(String name) {
        List<String> values = this.getHeaders().get(HeaderName.of(name));
        return values.isEmpty() ? null : values.get(0);
    }

    public List<String> getHeaders(String name) {
        return this.headers.get(HeaderName.of(name));
    }

    public ListMultimap<HeaderName, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("request", this.request).add("statusCode", this.statusCode).add("statusMessage", this.statusMessage).add("headers", this.headers).toString();
    }
}

