/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.client.http;

import com.facebook.presto.jdbc.internal.jetty.client.HttpChannel;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpReceiver;
import com.facebook.presto.jdbc.internal.jetty.client.HttpResponse;
import com.facebook.presto.jdbc.internal.jetty.http.HttpField;
import com.facebook.presto.jdbc.internal.jetty.http.HttpFields;
import com.facebook.presto.jdbc.internal.jetty.http.MetaData;
import com.facebook.presto.jdbc.internal.jetty.http2.ErrorCode;
import com.facebook.presto.jdbc.internal.jetty.http2.api.Stream;
import com.facebook.presto.jdbc.internal.jetty.http2.client.http.HttpChannelOverHTTP2;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.DataFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.HeadersFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.PushPromiseFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.ResetFrame;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.CompletableCallback;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements Stream.Listener {
    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    @Override
    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    @Override
    public void onHeaders(Stream stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse response = exchange.getResponse();
        MetaData.Response metaData = (MetaData.Response)frame.getMetaData();
        response.version(metaData.getVersion()).status(metaData.getStatus()).reason(metaData.getReason());
        if (this.responseBegin(exchange)) {
            HttpFields headers = metaData.getFields();
            for (HttpField header : headers) {
                if (this.responseHeader(exchange, header)) continue;
                return;
            }
            if (this.responseHeaders(exchange) && frame.isEndStream()) {
                this.responseSuccess(exchange);
            }
        }
    }

    @Override
    public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
        return null;
    }

    @Override
    public void onData(Stream stream, final DataFrame frame, final Callback callback) {
        final HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            callback.failed(new IOException("terminated"));
            return;
        }
        final ByteBufferPool byteBufferPool = this.getHttpDestination().getHttpClient().getByteBufferPool();
        ByteBuffer original = frame.getData();
        int length = original.remaining();
        final ByteBuffer copy = byteBufferPool.acquire(length, original.isDirect());
        BufferUtil.clearToFill(copy);
        copy.put(original);
        BufferUtil.flipToFlush(copy, 0);
        CompletableCallback delegate = new CompletableCallback(){

            @Override
            public void succeeded() {
                byteBufferPool.release(copy);
                callback.succeeded();
                super.succeeded();
            }

            @Override
            public void failed(Throwable x) {
                byteBufferPool.release(copy);
                callback.failed(x);
                super.failed(x);
            }

            @Override
            public void resume() {
                if (frame.isEndStream()) {
                    HttpReceiverOverHTTP2.this.responseSuccess(exchange);
                }
            }

            @Override
            public void abort(Throwable failure) {
            }
        };
        this.responseContent(exchange, copy, delegate);
        if (!delegate.tryComplete()) {
            delegate.resume();
        }
    }

    @Override
    public void onReset(Stream stream, ResetFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        ErrorCode error = ErrorCode.from(frame.getError());
        String reason = error == null ? "reset" : error.name().toLowerCase(Locale.ENGLISH);
        exchange.getRequest().abort(new IOException(reason));
    }

    @Override
    public void onTimeout(Stream stream, Throwable failure) {
        this.responseFailure(failure);
    }
}

