/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.spi.block.ShortArrayBlock;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;

public class ShortArrayBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<ShortArrayBlockEncoding> FACTORY = new ShortArrayBlockEncodingFactory();
    private static final String NAME = "SHORT_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        for (int position = 0; position < positionCount; ++position) {
            if (block.isNull(position)) continue;
            sliceOutput.writeShort(block.getShort(position, 0));
        }
    }

    @Override
    public int getEstimatedSize(Block block) {
        int positionCount = block.getPositionCount();
        int size = 4;
        size += positionCount / 8 + 1;
        for (int position = 0; position < positionCount; ++position) {
            if (block.isNull(position)) continue;
            size += 2;
        }
        return size;
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        short[] values = new short[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            if (valueIsNull[position]) continue;
            values[position] = sliceInput.readShort();
        }
        return new ShortArrayBlock(positionCount, valueIsNull, values);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class ShortArrayBlockEncodingFactory
    implements BlockEncodingFactory<ShortArrayBlockEncoding> {
        @Override
        public String getName() {
            return ShortArrayBlockEncoding.NAME;
        }

        @Override
        public ShortArrayBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            return new ShortArrayBlockEncoding();
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, ShortArrayBlockEncoding blockEncoding) {
        }
    }
}

