/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.ShortArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.AbstractType;
import com.facebook.presto.jdbc.internal.spi.type.FixedWidthType;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;

public final class SmallintType
extends AbstractType
implements FixedWidthType {
    public static final SmallintType SMALLINT = new SmallintType();

    private SmallintType() {
        super(TypeSignature.parseTypeSignature("smallint"), Long.TYPE);
    }

    @Override
    public int getFixedSize() {
        return 2;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new ShortArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, blockBuilderStatus.getMaxBlockSizeInBytes() / 2));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 2);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ShortArrayBlockBuilder(new BlockBuilderStatus(), positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getShort(position, 0);
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        short rightValue;
        short leftValue = leftBlock.getShort(leftPosition, 0);
        return leftValue == (rightValue = rightBlock.getShort(rightPosition, 0));
    }

    @Override
    public long hash(Block block, int position) {
        return block.getShort(position, 0);
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        short leftValue = leftBlock.getShort(leftPosition, 0);
        short rightValue = rightBlock.getShort(rightPosition, 0);
        return Short.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeShort(block.getShort(position, 0)).closeEntry();
        }
    }

    @Override
    public long getLong(Block block, int position) {
        return block.getShort(position, 0);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        if (value > 32767L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, String.format("Value %d exceeds MAX_SHORT", value));
        }
        if (value < -32768L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, String.format("Value %d is less than MIN_SHORT", value));
        }
        blockBuilder.writeShort((int)value).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == SMALLINT;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

