/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2;

import com.facebook.presto.jdbc.internal.jetty.http2.ErrorCode;
import com.facebook.presto.jdbc.internal.jetty.http2.ISession;
import com.facebook.presto.jdbc.internal.jetty.http2.parser.Parser;
import com.facebook.presto.jdbc.internal.jetty.io.AbstractConnection;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.ConcurrentArrayQueue;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import com.facebook.presto.jdbc.internal.jetty.util.thread.ExecutionStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.Executor;

public class HTTP2Connection
extends AbstractConnection {
    protected static final Logger LOG = Log.getLogger(HTTP2Connection.class);
    private final Queue<Runnable> tasks = new ConcurrentArrayQueue<Runnable>();
    private final ByteBufferPool byteBufferPool;
    private final Parser parser;
    private final ISession session;
    private final int bufferSize;
    private final HTTP2Producer producer = new HTTP2Producer();
    private final ExecutionStrategy executionStrategy;

    public HTTP2Connection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, Parser parser, ISession session, int bufferSize) {
        super(endPoint, executor);
        this.byteBufferPool = byteBufferPool;
        this.parser = parser;
        this.session = session;
        this.bufferSize = bufferSize;
        this.executionStrategy = ExecutionStrategy.Factory.instanceFor(this.producer, executor);
    }

    public ISession getSession() {
        return this.session;
    }

    protected Parser getParser() {
        return this.parser;
    }

    protected void setInputBuffer(ByteBuffer buffer) {
        this.producer.buffer = buffer;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Open {} ", this);
        }
        super.onOpen();
        this.executionStrategy.execute();
    }

    @Override
    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Close {} ", this);
        }
        super.onClose();
    }

    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onFillable {} ", this);
        }
        this.executionStrategy.execute();
    }

    private int fill(EndPoint endPoint, ByteBuffer buffer) {
        try {
            if (endPoint.isInputShutdown()) {
                return -1;
            }
            return endPoint.fill(buffer);
        }
        catch (IOException x) {
            LOG.debug("Could not read from " + endPoint, x);
            return -1;
        }
    }

    @Override
    public boolean onIdleExpired() {
        boolean close = this.session.onIdleTimeout();
        boolean idle = this.isFillInterested();
        if (close && idle) {
            this.session.close(ErrorCode.NO_ERROR.code, "idle_timeout", Callback.NOOP);
        }
        return false;
    }

    protected void offerTask(Runnable task, boolean dispatch) {
        this.tasks.offer(task);
        if (dispatch) {
            this.executionStrategy.dispatch();
        } else {
            this.executionStrategy.execute();
        }
    }

    @Override
    public void close() {
        this.session.close(ErrorCode.NO_ERROR.code, "close", Callback.NOOP);
    }

    protected class HTTP2Producer
    implements ExecutionStrategy.Producer {
        private ByteBuffer buffer;

        protected HTTP2Producer() {
        }

        @Override
        public Runnable produce() {
            Runnable task = (Runnable)HTTP2Connection.this.tasks.poll();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dequeued task {}", task);
            }
            if (task != null) {
                return task;
            }
            if (HTTP2Connection.this.isFillInterested()) {
                return null;
            }
            if (this.buffer == null) {
                this.buffer = HTTP2Connection.this.byteBufferPool.acquire(HTTP2Connection.this.bufferSize, false);
            }
            boolean looping = BufferUtil.hasContent(this.buffer);
            while (true) {
                if (looping) {
                    while (this.buffer.hasRemaining()) {
                        HTTP2Connection.this.parser.parse(this.buffer);
                    }
                    task = (Runnable)HTTP2Connection.this.tasks.poll();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Dequeued task {}", task);
                    }
                    if (task != null) {
                        this.release();
                        return task;
                    }
                }
                int filled = HTTP2Connection.this.fill(HTTP2Connection.this.getEndPoint(), this.buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled {} bytes", filled);
                }
                if (filled == 0) {
                    this.release();
                    HTTP2Connection.this.fillInterested();
                    return null;
                }
                if (filled < 0) {
                    this.release();
                    HTTP2Connection.this.session.onShutdown();
                    return null;
                }
                looping = true;
            }
        }

        private void release() {
            if (this.buffer != null && !this.buffer.hasRemaining()) {
                HTTP2Connection.this.byteBufferPool.release(this.buffer);
                this.buffer = null;
            }
        }
    }
}

