/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.InterleavedBlock;
import com.facebook.presto.jdbc.internal.spi.block.InterleavedBlockEncoding;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractInterleavedBlock
implements Block {
    private final int columns;

    protected abstract Block getBlock(int var1);

    protected abstract int toAbsolutePosition(int var1);

    @Override
    public abstract InterleavedBlockEncoding getEncoding();

    protected AbstractInterleavedBlock(int columns) {
        if (columns <= 0) {
            throw new IllegalArgumentException("Number of blocks in InterleavedBlock must be positive");
        }
        this.columns = columns;
    }

    int getBlockCount() {
        return this.columns;
    }

    Block[] computeSerializableSubBlocks() {
        InterleavedBlock interleavedBlock = (InterleavedBlock)this.sliceRange(0, this.getPositionCount(), false);
        Block[] result = new Block[interleavedBlock.getBlockCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = interleavedBlock.getBlock(i);
        }
        return result;
    }

    protected InterleavedBlockEncoding computeBlockEncoding() {
        BlockEncoding[] individualBlockEncodings = new BlockEncoding[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            Block block = this.getBlock(i);
            individualBlockEncodings[i] = block.getEncoding();
        }
        return new InterleavedBlockEncoding(individualBlockEncodings);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        this.getBlock(blockIndex).writePositionTo(positionInBlock, blockBuilder);
    }

    @Override
    public byte getByte(int position, int offset) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).getByte(positionInBlock, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).getShort(positionInBlock, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).getInt(positionInBlock, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).getLong(positionInBlock, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).getSlice(positionInBlock, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).getObject(positionInBlock, clazz);
    }

    @Override
    public int getLength(int position) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).getLength(positionInBlock);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).equals(positionInBlock, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).bytesEqual(positionInBlock, offset, otherSlice, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).hash(positionInBlock, offset, length);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).compareTo(positionInBlock, offset, length, otherBlock, otherPosition, otherOffset, otherLength);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).bytesCompare(positionInBlock, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        this.getBlock(blockIndex).writeBytesTo(positionInBlock, offset, length, blockBuilder);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).getSingleValueBlock(positionInBlock);
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        if (positions.size() % this.columns != 0) {
            throw new IllegalArgumentException("Positions.size (" + positions.size() + ") is not evenly dividable by columns (" + this.columns + ")");
        }
        int positionsPerColumn = positions.size() / this.columns;
        ArrayList valuePositions = new ArrayList(this.columns);
        for (int i = 0; i < this.columns; ++i) {
            valuePositions.add(new ArrayList(positionsPerColumn));
        }
        int ordinal = 0;
        for (int position : positions) {
            if (ordinal % this.columns != (position = this.toAbsolutePosition(position)) % this.columns) {
                throw new IllegalArgumentException("Position (" + position + ") is not congruent to ordinal (" + ordinal + ") modulo columns (" + this.columns + ")");
            }
            ((List)valuePositions.get(position % this.columns)).add(position / this.columns);
            ++ordinal;
        }
        Block[] blocks = new Block[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            blocks[i] = this.getBlock(i).copyPositions((List)valuePositions.get(i));
        }
        return new InterleavedBlock(blocks);
    }

    @Override
    public Block copyRegion(int position, int length) {
        this.validateRange(position, length);
        return this.sliceRange(position, length, true);
    }

    protected void validateRange(int position, int length) {
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount || position % this.columns != 0 || length % this.columns != 0) {
            throw new IndexOutOfBoundsException("Invalid position (" + position + "), length (" + length + ") in InterleavedBlock with " + positionCount + " positions and " + this.columns + " columns");
        }
    }

    protected Block sliceRange(int position, int length, boolean compact) {
        position = this.toAbsolutePosition(position);
        Block[] resultBlocks = new Block[this.columns];
        int positionInBlock = position / this.columns;
        int subBlockLength = length / this.columns;
        for (int blockIndex = 0; blockIndex < this.columns; ++blockIndex) {
            resultBlocks[blockIndex] = compact ? this.getBlock((blockIndex + position) % this.columns).copyRegion(positionInBlock, subBlockLength) : this.getBlock((blockIndex + position) % this.columns).getRegion(positionInBlock, subBlockLength);
        }
        return new InterleavedBlock(resultBlocks);
    }

    @Override
    public boolean isNull(int position) {
        position = this.toAbsolutePosition(position);
        int blockIndex = position % this.columns;
        int positionInBlock = position / this.columns;
        return this.getBlock(blockIndex).isNull(positionInBlock);
    }
}

