/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import com.facebook.presto.jdbc.internal.spi.CatalogSchemaTableName;
import com.facebook.presto.jdbc.internal.spi.security.AccessDeniedException;
import com.facebook.presto.jdbc.internal.spi.security.Identity;
import com.facebook.presto.jdbc.internal.spi.security.Privilege;
import java.security.Principal;

public interface SystemAccessControl {
    public void checkCanSetUser(Principal var1, String var2);

    public void checkCanSetSystemSessionProperty(Identity var1, String var2);

    default public void checkCanCreateTable(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyCreateTable(table.toString());
    }

    default public void checkCanDropTable(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyDropTable(table.toString());
    }

    default public void checkCanRenameTable(Identity identity, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        AccessDeniedException.denyRenameTable(table.toString(), newTable.toString());
    }

    default public void checkCanAddColumn(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyAddColumn(table.toString());
    }

    default public void checkCanRenameColumn(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyRenameColumn(table.toString());
    }

    default public void checkCanSelectFromTable(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denySelectTable(table.toString());
    }

    default public void checkCanInsertIntoTable(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyInsertTable(table.toString());
    }

    default public void checkCanDeleteFromTable(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyDeleteTable(table.toString());
    }

    default public void checkCanCreateView(Identity identity, CatalogSchemaTableName view) {
        AccessDeniedException.denyCreateView(view.toString());
    }

    default public void checkCanDropView(Identity identity, CatalogSchemaTableName view) {
        AccessDeniedException.denyDropView(view.toString());
    }

    default public void checkCanSelectFromView(Identity identity, CatalogSchemaTableName view) {
        AccessDeniedException.denySelectView(view.toString());
    }

    default public void checkCanCreateViewWithSelectFromTable(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyCreateViewWithSelect(table.toString());
    }

    default public void checkCanCreateViewWithSelectFromView(Identity identity, CatalogSchemaTableName view) {
        AccessDeniedException.denyCreateViewWithSelect(view.toString());
    }

    default public void checkCanSetCatalogSessionProperty(Identity identity, String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(propertyName);
    }

    default public void checkCanGrantTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table) {
        AccessDeniedException.denyGrantTablePrivilege(privilege.toString(), table.toString());
    }

    default public void checkCanRevokeTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege.toString(), table.toString());
    }
}

