/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2;

import com.facebook.presto.jdbc.internal.jetty.http2.CloseState;
import com.facebook.presto.jdbc.internal.jetty.http2.ErrorCode;
import com.facebook.presto.jdbc.internal.jetty.http2.ISession;
import com.facebook.presto.jdbc.internal.jetty.http2.IStream;
import com.facebook.presto.jdbc.internal.jetty.http2.api.Stream;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.DataFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.Frame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.HeadersFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.PushPromiseFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.ResetFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.WindowUpdateFrame;
import com.facebook.presto.jdbc.internal.jetty.io.IdleTimeout;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.Promise;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import com.facebook.presto.jdbc.internal.jetty.util.thread.Scheduler;
import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class HTTP2Stream
extends IdleTimeout
implements IStream {
    private static final Logger LOG = Log.getLogger(HTTP2Stream.class);
    private final AtomicReference<ConcurrentMap<String, Object>> attributes = new AtomicReference();
    private final AtomicReference<CloseState> closeState = new AtomicReference<CloseState>(CloseState.NOT_CLOSED);
    private final AtomicInteger sendWindow = new AtomicInteger();
    private final AtomicInteger recvWindow = new AtomicInteger();
    private final ISession session;
    private final int streamId;
    private final boolean local;
    private volatile Stream.Listener listener;
    private volatile boolean localReset;
    private volatile boolean remoteReset;

    public HTTP2Stream(Scheduler scheduler, ISession session, int streamId, boolean local) {
        super(scheduler);
        this.session = session;
        this.streamId = streamId;
        this.local = local;
    }

    @Override
    public int getId() {
        return this.streamId;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public ISession getSession() {
        return this.session;
    }

    @Override
    public void headers(HeadersFrame frame, Callback callback) {
        this.session.frames(this, callback, frame, Frame.EMPTY_ARRAY);
    }

    @Override
    public void push(PushPromiseFrame frame, Promise<Stream> promise, Stream.Listener listener) {
        this.session.push(this, promise, frame, listener);
    }

    @Override
    public void data(DataFrame frame, Callback callback) {
        this.session.data(this, callback, frame);
    }

    @Override
    public void reset(ResetFrame frame, Callback callback) {
        if (this.isReset()) {
            return;
        }
        this.localReset = true;
        this.session.frames(this, callback, frame, Frame.EMPTY_ARRAY);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes().get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes().put(key, value);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes().remove(key);
    }

    @Override
    public boolean isReset() {
        return this.localReset || this.remoteReset;
    }

    @Override
    public boolean isClosed() {
        return this.closeState.get() == CloseState.CLOSED;
    }

    public boolean isRemotelyClosed() {
        return this.closeState.get() == CloseState.REMOTELY_CLOSED;
    }

    public boolean isLocallyClosed() {
        return this.closeState.get() == CloseState.LOCALLY_CLOSED;
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed();
    }

    @Override
    protected void onIdleExpired(TimeoutException timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Idle timeout {}ms expired on {}", this.getIdleTimeout(), this);
        }
        this.close();
        this.reset(new ResetFrame(this.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        this.notifyTimeout(this, timeout);
    }

    private ConcurrentMap<String, Object> attributes() {
        ConcurrentMap<String, Object> map = this.attributes.get();
        if (map == null && !this.attributes.compareAndSet(null, map = new ConcurrentHashMap<String, Object>())) {
            map = this.attributes.get();
        }
        return map;
    }

    @Override
    public Stream.Listener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(Stream.Listener listener) {
        this.listener = listener;
    }

    @Override
    public void process(Frame frame, Callback callback) {
        this.notIdle();
        switch (frame.getType()) {
            case HEADERS: {
                this.onHeaders((HeadersFrame)frame, callback);
                break;
            }
            case DATA: {
                this.onData((DataFrame)frame, callback);
                break;
            }
            case RST_STREAM: {
                this.onReset((ResetFrame)frame, callback);
                break;
            }
            case PUSH_PROMISE: {
                this.onPush((PushPromiseFrame)frame, callback);
                break;
            }
            case WINDOW_UPDATE: {
                this.onWindowUpdate((WindowUpdateFrame)frame, callback);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void onHeaders(HeadersFrame frame, Callback callback) {
        if (this.updateClose(frame.isEndStream(), false)) {
            this.session.removeStream(this);
        }
        callback.succeeded();
    }

    private void onData(DataFrame frame, Callback callback) {
        if (this.getRecvWindow() < 0) {
            this.session.close(ErrorCode.FLOW_CONTROL_ERROR.code, "stream_window_exceeded", Callback.NOOP);
            callback.failed(new IOException("stream_window_exceeded"));
            return;
        }
        if (this.isRemotelyClosed()) {
            this.reset(new ResetFrame(this.streamId, ErrorCode.STREAM_CLOSED_ERROR.code), Callback.NOOP);
            callback.failed(new EOFException("stream_closed"));
            return;
        }
        if (this.isReset()) {
            callback.failed(new IOException("stream_reset"));
            return;
        }
        if (this.updateClose(frame.isEndStream(), false)) {
            this.session.removeStream(this);
        }
        this.notifyData(this, frame, callback);
    }

    private void onReset(ResetFrame frame, Callback callback) {
        this.remoteReset = true;
        this.close();
        this.session.removeStream(this);
        callback.succeeded();
        this.notifyReset(this, frame);
    }

    private void onPush(PushPromiseFrame frame, Callback callback) {
        this.updateClose(true, true);
        callback.succeeded();
    }

    private void onWindowUpdate(WindowUpdateFrame frame, Callback callback) {
        callback.succeeded();
    }

    @Override
    public boolean updateClose(boolean update, boolean local) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update close for {} close={} local={}", this, update, local);
        }
        if (!update) {
            return false;
        }
        block5: while (true) {
            CloseState current = this.closeState.get();
            switch (current) {
                case NOT_CLOSED: {
                    CloseState newValue;
                    if (!this.closeState.compareAndSet(current, newValue = local ? CloseState.LOCALLY_CLOSED : CloseState.REMOTELY_CLOSED)) continue block5;
                    return false;
                }
                case LOCALLY_CLOSED: {
                    if (local) {
                        return false;
                    }
                    this.close();
                    return true;
                }
                case REMOTELY_CLOSED: {
                    if (!local) {
                        return false;
                    }
                    this.close();
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public int getSendWindow() {
        return this.sendWindow.get();
    }

    public int getRecvWindow() {
        return this.recvWindow.get();
    }

    @Override
    public int updateSendWindow(int delta) {
        return this.sendWindow.getAndAdd(delta);
    }

    @Override
    public int updateRecvWindow(int delta) {
        return this.recvWindow.getAndAdd(delta);
    }

    @Override
    public void close() {
        this.closeState.set(CloseState.CLOSED);
        this.onClose();
    }

    private void notifyData(Stream stream, DataFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        try {
            listener.onData(stream, frame, callback);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + listener, x);
        }
    }

    private void notifyReset(Stream stream, ResetFrame frame) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        try {
            listener.onReset(stream, frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + listener, x);
        }
    }

    private void notifyTimeout(Stream stream, Throwable failure) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        try {
            listener.onTimeout(stream, failure);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + listener, x);
        }
    }

    public String toString() {
        return String.format("%s@%x#%d{sendWindow=%s,recvWindow=%s,reset=%b,%s}", this.getClass().getSimpleName(), this.hashCode(), this.getId(), this.sendWindow, this.recvWindow, this.isReset(), this.closeState);
    }
}

