/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.frames;

import com.facebook.presto.jdbc.internal.jetty.http2.ErrorCode;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.Frame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.FrameType;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import java.nio.ByteBuffer;

public class GoAwayFrame
extends Frame {
    private final int lastStreamId;
    private final int error;
    private final byte[] payload;

    public GoAwayFrame(int lastStreamId, int error, byte[] payload) {
        super(FrameType.GO_AWAY);
        this.lastStreamId = lastStreamId;
        this.error = error;
        this.payload = payload;
    }

    public int getLastStreamId() {
        return this.lastStreamId;
    }

    public int getError() {
        return this.error;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String tryConvertPayload() {
        if (this.payload == null) {
            return "";
        }
        ByteBuffer buffer = BufferUtil.toBuffer(this.payload);
        try {
            return BufferUtil.toUTF8String(buffer);
        }
        catch (Throwable x) {
            return BufferUtil.toDetailString(buffer);
        }
    }

    @Override
    public String toString() {
        ErrorCode errorCode = ErrorCode.from(this.error);
        return String.format("%s,%d/%s/%s", super.toString(), this.lastStreamId, errorCode != null ? errorCode.toString() : String.valueOf(this.error), this.tryConvertPayload());
    }
}

