/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.hpack;

import java.nio.ByteBuffer;

public class Huffman {
    static final int[][] CODES = new int[][]{{8184, 13}, {8388568, 23}, {0xFFFFFE2, 28}, {0xFFFFFE3, 28}, {0xFFFFFE4, 28}, {0xFFFFFE5, 28}, {0xFFFFFE6, 28}, {0xFFFFFE7, 28}, {0xFFFFFE8, 28}, {0xFFFFEA, 24}, {0x3FFFFFFC, 30}, {0xFFFFFE9, 28}, {0xFFFFFEA, 28}, {0x3FFFFFFD, 30}, {0xFFFFFEB, 28}, {0xFFFFFEC, 28}, {0xFFFFFED, 28}, {0xFFFFFEE, 28}, {0xFFFFFEF, 28}, {0xFFFFFF0, 28}, {0xFFFFFF1, 28}, {0xFFFFFF2, 28}, {0x3FFFFFFE, 30}, {0xFFFFFF3, 28}, {0xFFFFFF4, 28}, {0xFFFFFF5, 28}, {0xFFFFFF6, 28}, {0xFFFFFF7, 28}, {0xFFFFFF8, 28}, {0xFFFFFF9, 28}, {0xFFFFFFA, 28}, {0xFFFFFFB, 28}, {20, 6}, {1016, 10}, {1017, 10}, {4090, 12}, {8185, 13}, {21, 6}, {248, 8}, {2042, 11}, {1018, 10}, {1019, 10}, {249, 8}, {2043, 11}, {250, 8}, {22, 6}, {23, 6}, {24, 6}, {0, 5}, {1, 5}, {2, 5}, {25, 6}, {26, 6}, {27, 6}, {28, 6}, {29, 6}, {30, 6}, {31, 6}, {92, 7}, {251, 8}, {32764, 15}, {32, 6}, {4091, 12}, {1020, 10}, {8186, 13}, {33, 6}, {93, 7}, {94, 7}, {95, 7}, {96, 7}, {97, 7}, {98, 7}, {99, 7}, {100, 7}, {101, 7}, {102, 7}, {103, 7}, {104, 7}, {105, 7}, {106, 7}, {107, 7}, {108, 7}, {109, 7}, {110, 7}, {111, 7}, {112, 7}, {113, 7}, {114, 7}, {252, 8}, {115, 7}, {253, 8}, {8187, 13}, {524272, 19}, {8188, 13}, {16380, 14}, {34, 6}, {32765, 15}, {3, 5}, {35, 6}, {4, 5}, {36, 6}, {5, 5}, {37, 6}, {38, 6}, {39, 6}, {6, 5}, {116, 7}, {117, 7}, {40, 6}, {41, 6}, {42, 6}, {7, 5}, {43, 6}, {118, 7}, {44, 6}, {8, 5}, {9, 5}, {45, 6}, {119, 7}, {120, 7}, {121, 7}, {122, 7}, {123, 7}, {32766, 15}, {2044, 11}, {16381, 14}, {8189, 13}, {0xFFFFFFC, 28}, {1048550, 20}, {4194258, 22}, {1048551, 20}, {1048552, 20}, {0x3FFFD3, 22}, {4194260, 22}, {4194261, 22}, {8388569, 23}, {4194262, 22}, {8388570, 23}, {8388571, 23}, {8388572, 23}, {0x7FFFDD, 23}, {8388574, 23}, {0xFFFFEB, 24}, {0x7FFFDF, 23}, {0xFFFFEC, 24}, {0xFFFFED, 24}, {4194263, 22}, {8388576, 23}, {0xFFFFEE, 24}, {8388577, 23}, {8388578, 23}, {8388579, 23}, {8388580, 23}, {2097116, 21}, {4194264, 22}, {8388581, 23}, {4194265, 22}, {8388582, 23}, {0x7FFFE7, 23}, {0xFFFFEF, 24}, {4194266, 22}, {0x1FFFDD, 21}, {1048553, 20}, {4194267, 22}, {4194268, 22}, {8388584, 23}, {8388585, 23}, {2097118, 21}, {8388586, 23}, {0x3FFFDD, 22}, {4194270, 22}, {0xFFFFF0, 24}, {0x1FFFDF, 21}, {0x3FFFDF, 22}, {8388587, 23}, {8388588, 23}, {2097120, 21}, {0x1FFFE1, 21}, {4194272, 22}, {2097122, 21}, {8388589, 23}, {4194273, 22}, {0x7FFFEE, 23}, {0x7FFFEF, 23}, {1048554, 20}, {4194274, 22}, {0x3FFFE3, 22}, {4194276, 22}, {0x7FFFF0, 23}, {4194277, 22}, {4194278, 22}, {0x7FFFF1, 23}, {67108832, 26}, {67108833, 26}, {1048555, 20}, {524273, 19}, {4194279, 22}, {0x7FFFF2, 23}, {4194280, 22}, {33554412, 25}, {67108834, 26}, {0x3FFFFE3, 26}, {67108836, 26}, {134217694, 27}, {0x7FFFFDF, 27}, {67108837, 26}, {0xFFFFF1, 24}, {33554413, 25}, {524274, 19}, {2097123, 21}, {67108838, 26}, {134217696, 27}, {134217697, 27}, {67108839, 26}, {134217698, 27}, {0xFFFFF2, 24}, {2097124, 21}, {2097125, 21}, {67108840, 26}, {67108841, 26}, {0xFFFFFFD, 28}, {134217699, 27}, {134217700, 27}, {134217701, 27}, {1048556, 20}, {0xFFFFF3, 24}, {1048557, 20}, {2097126, 21}, {4194281, 22}, {2097127, 21}, {2097128, 21}, {0x7FFFF3, 23}, {4194282, 22}, {4194283, 22}, {0x1FFFFEE, 25}, {0x1FFFFEF, 25}, {0xFFFFF4, 24}, {0xFFFFF5, 24}, {67108842, 26}, {0x7FFFF4, 23}, {67108843, 26}, {134217702, 27}, {67108844, 26}, {67108845, 26}, {0x7FFFFE7, 27}, {134217704, 27}, {134217705, 27}, {134217706, 27}, {134217707, 27}, {0xFFFFFFE, 28}, {134217708, 27}, {134217709, 27}, {0x7FFFFEE, 27}, {0x7FFFFEF, 27}, {0x7FFFFF0, 27}, {0x3FFFFEE, 26}, {0x3FFFFFFF, 30}};
    static final int[][] LCCODES = new int[CODES.length][];
    static final char[] tree;
    static final char[] rowsym;
    static final byte[] rowbits;

    public static String decode(ByteBuffer buffer) {
        return Huffman.decode(buffer, buffer.remaining());
    }

    public static String decode(ByteBuffer buffer, int length) {
        int c;
        StringBuilder out = new StringBuilder(length * 2);
        int node = 0;
        int current = 0;
        int bits = 0;
        byte[] array = buffer.array();
        int position = buffer.position();
        int start = buffer.arrayOffset() + position;
        int end = start + length;
        buffer.position(position + length);
        for (int i = start; i < end; ++i) {
            int b = array[i] & 0xFF;
            current = current << 8 | b;
            bits += 8;
            while (bits >= 8) {
                int c2 = current >>> bits - 8 & 0xFF;
                if (rowbits[node = tree[node * 256 + c2]] != 0) {
                    out.append(rowsym[node]);
                    bits -= rowbits[node];
                    node = 0;
                    continue;
                }
                bits -= 8;
            }
        }
        while (bits > 0 && rowbits[node = tree[node * 256 + (c = current << 8 - bits & 0xFF)]] != 0 && rowbits[node] <= bits) {
            if (rowbits[node] == 0) {
                throw new IllegalStateException();
            }
            out.append(rowsym[node]);
            bits -= rowbits[node];
            node = 0;
        }
        return out.toString();
    }

    public static int octetsNeeded(String s) {
        return Huffman.octetsNeeded(CODES, s);
    }

    public static void encode(ByteBuffer buffer, String s) {
        Huffman.encode(CODES, buffer, s);
    }

    public static int octetsNeededLC(String s) {
        return Huffman.octetsNeeded(LCCODES, s);
    }

    public static void encodeLC(ByteBuffer buffer, String s) {
        Huffman.encode(LCCODES, buffer, s);
    }

    private static int octetsNeeded(int[][] table, String s) {
        int needed = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0080' || c < ' ') {
                throw new IllegalArgumentException();
            }
            needed += table[c][1];
        }
        return (needed + 7) / 8;
    }

    private static void encode(int[][] table, ByteBuffer buffer, String s) {
        long current = 0L;
        int n = 0;
        byte[] array = buffer.array();
        int p = buffer.arrayOffset() + buffer.position();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0080' || c < ' ') {
                throw new IllegalArgumentException();
            }
            int code = table[c][0];
            int bits = table[c][1];
            current <<= bits;
            current |= (long)code;
            n += bits;
            while (n >= 8) {
                array[p++] = (byte)(current >> (n -= 8));
            }
        }
        if (n > 0) {
            current <<= 8 - n;
            array[p++] = (byte)(current |= (long)(255 >>> n));
        }
        buffer.position(p - buffer.arrayOffset());
    }

    static {
        System.arraycopy(CODES, 0, LCCODES, 0, CODES.length);
        for (int i = 65; i <= 90; ++i) {
            Huffman.LCCODES[i] = LCCODES[97 + i - 65];
        }
        int r = 0;
        for (int i = 0; i < CODES.length; ++i) {
            r += (CODES[i][1] + 7) / 8;
        }
        tree = new char[r * 256];
        rowsym = new char[r];
        rowbits = new byte[r];
        r = 0;
        for (int sym = 0; sym < CODES.length; ++sym) {
            int code = CODES[sym][0];
            int len = CODES[sym][1];
            int current = 0;
            while (len > 8) {
                int i = code >>> (len -= 8) & 0xFF;
                int t = current * 256 + i;
                if ((current = tree[t]) != 0) continue;
                Huffman.tree[t] = (char)(++r);
                current = r;
            }
            int terminal = ++r;
            Huffman.rowsym[r] = (char)sym;
            int b = len & 7;
            int terminalBits = b == 0 ? 8 : b;
            Huffman.rowbits[r] = (byte)terminalBits;
            int shift = 8 - len;
            int start = current * 256 + (code << shift & 0xFF);
            int end = start + (1 << shift);
            for (int i = start; i < end; ++i) {
                Huffman.tree[i] = (char)terminal;
            }
        }
    }
}

