/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.spnego;

import com.facebook.presto.jdbc.internal.airlift.http.client.spnego.SpnegoAuthentication;
import com.facebook.presto.jdbc.internal.airlift.http.client.spnego.UriUtil;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.guava.cache.Cache;
import com.facebook.presto.jdbc.internal.guava.cache.CacheBuilder;
import com.facebook.presto.jdbc.internal.jetty.client.api.Authentication;
import com.facebook.presto.jdbc.internal.jetty.client.api.AuthenticationStore;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class SpnegoAuthenticationStore
implements AuthenticationStore {
    private static final int CACHE_SIZE = 10000;
    private static final Duration CACHE_EXPIRE_TIME = new Duration(5.0, TimeUnit.MINUTES);
    private static final int CONCURRENCY_LEVEL = 16;
    private final Cache<URI, Authentication.Result> results;
    private final SpnegoAuthentication authentication;

    public SpnegoAuthenticationStore(SpnegoAuthentication authentication) {
        Objects.requireNonNull(authentication, "authentication is null");
        this.authentication = authentication;
        this.results = CacheBuilder.newBuilder().concurrencyLevel(16).maximumSize(10000L).expireAfterWrite(CACHE_EXPIRE_TIME.roundTo(TimeUnit.MINUTES), TimeUnit.MINUTES).build();
    }

    @Override
    public void addAuthentication(Authentication authentication) {
        throw new UnsupportedOperationException("addAuthentication is not supported");
    }

    @Override
    public void removeAuthentication(Authentication authentication) {
        throw new UnsupportedOperationException("removeAuthentication is not supported");
    }

    @Override
    public void clearAuthentications() {
        throw new UnsupportedOperationException("clearAuthentications is not supported");
    }

    @Override
    public Authentication findAuthentication(String type, URI uri, String realm) {
        if (this.authentication.matches(type, uri, realm)) {
            return this.authentication;
        }
        return null;
    }

    @Override
    public void addAuthenticationResult(Authentication.Result result) {
        this.results.put(UriUtil.normalizedUri(result.getURI()), result);
    }

    @Override
    public void removeAuthenticationResult(Authentication.Result result) {
        this.results.invalidate(UriUtil.normalizedUri(result.getURI()));
    }

    @Override
    public void clearAuthenticationResults() {
        this.results.invalidateAll();
    }

    @Override
    public Authentication.Result findAuthenticationResult(URI uri) {
        Objects.requireNonNull(uri, "uri is null");
        if ("https".equalsIgnoreCase(uri.getScheme())) {
            return this.results.getIfPresent(UriUtil.normalizedUri(uri));
        }
        return null;
    }
}

