/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.client;

import com.facebook.presto.jdbc.internal.jetty.alpn.client.ALPNClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.http2.BufferingFlowControlStrategy;
import com.facebook.presto.jdbc.internal.jetty.http2.FlowControlStrategy;
import com.facebook.presto.jdbc.internal.jetty.http2.api.Session;
import com.facebook.presto.jdbc.internal.jetty.http2.client.HTTP2ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.io.ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.io.Connection;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.ManagedSelector;
import com.facebook.presto.jdbc.internal.jetty.io.MappedByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.io.SelectChannelEndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.SelectorManager;
import com.facebook.presto.jdbc.internal.jetty.io.ssl.SslClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.util.Promise;
import com.facebook.presto.jdbc.internal.jetty.util.annotation.ManagedAttribute;
import com.facebook.presto.jdbc.internal.jetty.util.annotation.ManagedObject;
import com.facebook.presto.jdbc.internal.jetty.util.component.ContainerLifeCycle;
import com.facebook.presto.jdbc.internal.jetty.util.ssl.SslContextFactory;
import com.facebook.presto.jdbc.internal.jetty.util.thread.ExecutionStrategy;
import com.facebook.presto.jdbc.internal.jetty.util.thread.QueuedThreadPool;
import com.facebook.presto.jdbc.internal.jetty.util.thread.ScheduledExecutorScheduler;
import com.facebook.presto.jdbc.internal.jetty.util.thread.Scheduler;
import com.facebook.presto.jdbc.internal.jetty.util.thread.strategy.ProduceConsume;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

@ManagedObject
public class HTTP2Client
extends ContainerLifeCycle {
    private Executor executor;
    private Scheduler scheduler;
    private ByteBufferPool bufferPool;
    private ClientConnectionFactory connectionFactory;
    private SelectorManager selector;
    private int selectors = 1;
    private long idleTimeout = 30000L;
    private long connectTimeout = 10000L;
    private int inputBufferSize = 8192;
    private List<String> protocols = Arrays.asList("h2", "h2-17", "h2-16", "h2-15", "h2-14");
    private int initialSessionRecvWindow = 65535;
    private int initialStreamRecvWindow = 65535;
    private FlowControlStrategy.Factory flowControlStrategyFactory = () -> new BufferingFlowControlStrategy(0.5f);
    private ExecutionStrategy.Factory executionStrategyFactory = new ProduceConsume.Factory();

    @Override
    protected void doStart() throws Exception {
        if (this.executor == null) {
            this.setExecutor(new QueuedThreadPool());
        }
        if (this.scheduler == null) {
            this.setScheduler(new ScheduledExecutorScheduler());
        }
        if (this.bufferPool == null) {
            this.setByteBufferPool(new MappedByteBufferPool());
        }
        if (this.connectionFactory == null) {
            HTTP2ClientConnectionFactory h2 = new HTTP2ClientConnectionFactory();
            this.setClientConnectionFactory((endPoint, context) -> {
                ClientConnectionFactory factory = h2;
                SslContextFactory sslContextFactory = (SslContextFactory)context.get("ssl.context.factory");
                if (sslContextFactory != null) {
                    ALPNClientConnectionFactory alpn = new ALPNClientConnectionFactory(this.getExecutor(), h2, this.getProtocols());
                    factory = new SslClientConnectionFactory(sslContextFactory, this.getByteBufferPool(), this.getExecutor(), alpn);
                }
                return factory.newConnection(endPoint, context);
            });
        }
        if (this.selector == null) {
            this.selector = this.newSelectorManager();
            this.addBean(this.selector);
        }
        this.selector.setConnectTimeout(this.getConnectTimeout());
        super.doStart();
    }

    protected SelectorManager newSelectorManager() {
        return new ClientSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors());
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.updateBean(this.executor, executor);
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.updateBean(this.scheduler, scheduler);
        this.scheduler = scheduler;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public void setByteBufferPool(ByteBufferPool bufferPool) {
        this.updateBean(this.bufferPool, bufferPool);
        this.bufferPool = bufferPool;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    public void setClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        this.updateBean(this.connectionFactory, connectionFactory);
        this.connectionFactory = connectionFactory;
    }

    public FlowControlStrategy.Factory getFlowControlStrategyFactory() {
        return this.flowControlStrategyFactory;
    }

    public void setFlowControlStrategyFactory(FlowControlStrategy.Factory flowControlStrategyFactory) {
        this.flowControlStrategyFactory = flowControlStrategyFactory;
    }

    public ExecutionStrategy.Factory getExecutionStrategyFactory() {
        return this.executionStrategyFactory;
    }

    public void setExecutionStrategyFactory(ExecutionStrategy.Factory executionStrategyFactory) {
        this.executionStrategyFactory = executionStrategyFactory;
    }

    @ManagedAttribute(value="The number of selectors")
    public int getSelectors() {
        return this.selectors;
    }

    public void setSelectors(int selectors) {
        this.selectors = selectors;
    }

    @ManagedAttribute(value="The idle timeout in milliseconds")
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @ManagedAttribute(value="The connect timeout in milliseconds")
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        SelectorManager selector = this.selector;
        if (selector != null) {
            selector.setConnectTimeout(connectTimeout);
        }
    }

    @ManagedAttribute(value="The size of the buffer used to read from the network")
    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    @ManagedAttribute(value="The ALPN protocol list")
    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    @ManagedAttribute(value="The initial size of session's flow control receive window")
    public int getInitialSessionRecvWindow() {
        return this.initialSessionRecvWindow;
    }

    public void setInitialSessionRecvWindow(int initialSessionRecvWindow) {
        this.initialSessionRecvWindow = initialSessionRecvWindow;
    }

    @ManagedAttribute(value="The initial size of stream's flow control receive window")
    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    public void setInitialStreamRecvWindow(int initialStreamRecvWindow) {
        this.initialStreamRecvWindow = initialStreamRecvWindow;
    }

    public void connect(InetSocketAddress address, Session.Listener listener, Promise<Session> promise) {
        this.connect(null, address, listener, promise);
    }

    public void connect(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise) {
        this.connect(sslContextFactory, address, listener, promise, null);
    }

    public void connect(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        try {
            SocketChannel channel = SocketChannel.open();
            this.configure(channel);
            channel.configureBlocking(false);
            context = this.contextFrom(sslContextFactory, address, listener, promise, context);
            if (channel.connect(address)) {
                this.selector.accept(channel, context);
            } else {
                this.selector.connect(channel, context);
            }
        }
        catch (Throwable x) {
            promise.failed(x);
        }
    }

    public void accept(SslContextFactory sslContextFactory, SocketChannel channel, Session.Listener listener, Promise<Session> promise) {
        try {
            if (!channel.isConnected()) {
                throw new IllegalStateException("SocketChannel must be connected");
            }
            channel.configureBlocking(false);
            Map<String, Object> context = this.contextFrom(sslContextFactory, (InetSocketAddress)channel.getRemoteAddress(), listener, promise, null);
            this.selector.accept(channel, context);
        }
        catch (Throwable x) {
            promise.failed(x);
        }
    }

    private Map<String, Object> contextFrom(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("http2.client", this);
        context.put("http2.client.sessionListener", listener);
        context.put("http2.client.sessionPromise", promise);
        if (sslContextFactory != null) {
            context.put("ssl.context.factory", sslContextFactory);
        }
        context.put("ssl.peer.host", address.getHostString());
        context.put("ssl.peer.port", address.getPort());
        context.putIfAbsent("client.connector", this);
        return context;
    }

    protected void configure(SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(true);
    }

    private class ClientSelectorManager
    extends SelectorManager {
        private ClientSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        @Override
        protected EndPoint newEndPoint(SocketChannel channel, ManagedSelector selector, SelectionKey selectionKey) throws IOException {
            return new SelectChannelEndPoint(channel, selector, selectionKey, this.getScheduler(), HTTP2Client.this.getIdleTimeout());
        }

        @Override
        public Connection newConnection(SocketChannel channel, EndPoint endpoint, Object attachment) throws IOException {
            Map context = (Map)attachment;
            context.put("http2.client.byteBufferPool", HTTP2Client.this.getByteBufferPool());
            context.put("http2.client.executor", this.getExecutor());
            context.put("http2.client.scheduler", this.getScheduler());
            return HTTP2Client.this.getClientConnectionFactory().newConnection(endpoint, context);
        }

        @Override
        protected void connectionFailed(SocketChannel channel, Throwable failure, Object attachment) {
            Map context = (Map)attachment;
            if (LOG.isDebugEnabled()) {
                Object host = context.get("ssl.peer.host");
                Object port = context.get("ssl.peer.port");
                LOG.debug("Could not connect to {}:{}", host, port);
            }
            Promise promise = (Promise)context.get("http2.client.sessionPromise");
            promise.failed(failure);
        }
    }
}

