/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.HttpRequestFilter;
import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Predicate;

public class BasicAuthRequestFilter
implements HttpRequestFilter {
    private final Predicate<Request> requestMatcher;
    private final String authenticationHeader;

    public BasicAuthRequestFilter(String user, String password) {
        this(request -> true, user, password);
    }

    public BasicAuthRequestFilter(Predicate<Request> requestMatcher, String user, String password) {
        this.requestMatcher = Objects.requireNonNull(requestMatcher, "requestMatcher is null");
        this.authenticationHeader = BasicAuthRequestFilter.createAuthenticationHeader(user, password);
    }

    private static String createAuthenticationHeader(String user, String password) {
        Objects.requireNonNull(user, "user is null");
        Preconditions.checkArgument(!user.contains(":"), "Illegal character ':' found in username");
        Objects.requireNonNull(password, "password is null");
        return "Basic " + Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.ISO_8859_1));
    }

    @Override
    public Request filterRequest(Request request) {
        if (!this.requestMatcher.test(request)) {
            return request;
        }
        return Request.Builder.fromRequest(request).addHeader("Authorization", this.authenticationHeader).build();
    }
}

