/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.generator;

import com.facebook.presto.jdbc.internal.jetty.http2.frames.FrameType;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import java.nio.ByteBuffer;

public class HeaderGenerator {
    private int maxFrameSize = 16384;

    public ByteBuffer generate(ByteBufferPool.Lease lease, FrameType frameType, int capacity, int length, int flags, int streamId) {
        ByteBuffer header = lease.acquire(capacity, true);
        header.put((byte)((length & 0xFF0000) >>> 16));
        header.put((byte)((length & 0xFF00) >>> 8));
        header.put((byte)(length & 0xFF));
        header.put((byte)frameType.getType());
        header.put((byte)flags);
        header.putInt(streamId);
        return header;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }
}

