/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.SliceArrayBlockEncoding;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import sun.misc.Unsafe;

public class SliceArrayBlock
extends AbstractVariableWidthBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceArrayBlock.class).instanceSize();
    private static final int SLICE_INSTANCE_SIZE = ClassLayout.parseClass(Slice.class).instanceSize();
    private final int positionCount;
    private final Slice[] values;
    private final int sizeInBytes;
    private final int retainedSizeInBytes;

    public SliceArrayBlock(int positionCount, Slice[] values) {
        this(positionCount, values, false);
    }

    public SliceArrayBlock(int positionCount, Slice[] values, boolean valueSlicesAreDistinct) {
        this.positionCount = positionCount;
        if (values.length < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        this.sizeInBytes = SliceArrayBlock.getSliceArraySizeInBytes(values);
        this.retainedSizeInBytes = INSTANCE_SIZE + (valueSlicesAreDistinct ? this.sizeInBytes : SliceArrayBlock.getSliceArrayRetainedSizeInBytes(values));
    }

    public Slice[] getValues() {
        return this.values;
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.values[position];
    }

    @Override
    protected int getPositionOffset(int position) {
        return 0;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.values[position] == null;
    }

    @Override
    public BlockEncoding getEncoding() {
        return new SliceArrayBlockEncoding();
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockUtil.checkValidPositions(positions, this.positionCount);
        Slice[] newValues = new Slice[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            if (this.isEntryNull(positions.get(i))) continue;
            newValues[i] = Slices.copyOf(this.values[positions.get(i)]);
        }
        return new SliceArrayBlock(positions.size(), newValues);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSliceLength(int position) {
        return this.values[position].length();
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        Slice[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new SliceArrayBlock(length, newValues);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        return new SliceArrayBlock(length, SliceArrayBlock.deepCopyAndCompact(this.values, positionOffset, length));
    }

    static Slice[] deepCopyAndCompact(Slice[] values, int positionOffset, int length) {
        Slice[] newValues = Arrays.copyOfRange(values, positionOffset, positionOffset + length);
        IdentityHashMap<Slice, Slice> distinctValues = new IdentityHashMap<Slice, Slice>();
        for (int i = 0; i < newValues.length; ++i) {
            Slice slice = newValues[i];
            if (slice == null) continue;
            Slice distinct = (Slice)distinctValues.get(slice);
            if (distinct == null) {
                distinct = Slices.copyOf(slice);
                distinctValues.put(slice, distinct);
            }
            newValues[i] = distinct;
        }
        return newValues;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SliceArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    public static int getSliceArraySizeInBytes(Slice[] values) {
        long sizeInBytes = (long)values.length * (long)(Unsafe.ARRAY_OBJECT_INDEX_SCALE + SLICE_INSTANCE_SIZE);
        for (Slice value : values) {
            if (value == null) continue;
            sizeInBytes += (long)value.length();
        }
        return BlockUtil.intSaturatedCast(sizeInBytes);
    }

    @Override
    public int getRegionSizeInBytes(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset == 0 && length == positionCount) {
            return this.getSizeInBytes();
        }
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        long sizeInBytes = (long)length * (long)(Unsafe.ARRAY_OBJECT_INDEX_SCALE + SLICE_INSTANCE_SIZE);
        for (int i = positionOffset; i < positionOffset + length; ++i) {
            Slice value = this.values[i];
            if (value == null) continue;
            sizeInBytes += (long)value.length();
        }
        return BlockUtil.intSaturatedCast(sizeInBytes);
    }

    static int getSliceArrayRetainedSizeInBytes(Slice[] values) {
        long sizeInBytes = SizeOf.sizeOf(values);
        IdentityHashMap<Object, Boolean> uniqueRetained = new IdentityHashMap<Object, Boolean>(values.length);
        for (Slice value : values) {
            if (value == null || value.getBase() == null || uniqueRetained.put(value.getBase(), true) != null) continue;
            sizeInBytes += (long)value.getRetainedSize();
        }
        return BlockUtil.intSaturatedCast(sizeInBytes);
    }
}

