/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.DecimalParseResult;
import com.facebook.presto.jdbc.internal.spi.type.DecimalType;
import com.facebook.presto.jdbc.internal.spi.type.LongDecimalType;
import com.facebook.presto.jdbc.internal.spi.type.ShortDecimalType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Decimals {
    public static final int SIZE_OF_LONG_DECIMAL = 16;
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SHORT_PRECISION = 17;
    public static final BigInteger MAX_DECIMAL_UNSCALED_VALUE;
    public static final BigInteger MIN_DECIMAL_UNSCALED_VALUE;
    private static final Pattern DECIMAL_PATTERN;
    private static final int LONG_POWERS_OF_TEN_TABLE_LENGTH = 19;
    private static final int BIG_INTEGER_POWERS_OF_TEN_TABLE_LENGTH = 100;
    private static final long[] LONG_POWERS_OF_TEN;
    private static final BigInteger[] BIG_INTEGER_POWERS_OF_TEN;

    private Decimals() {
    }

    public static long longTenToNth(int n) {
        return LONG_POWERS_OF_TEN[n];
    }

    public static BigInteger bigIntegerTenToNth(int n) {
        return BIG_INTEGER_POWERS_OF_TEN[n];
    }

    public static DecimalParseResult parse(String stringValue) {
        return Decimals.parse(stringValue, false);
    }

    public static DecimalParseResult parseIncludeLeadingZerosInPrecision(String stringValue) {
        return Decimals.parse(stringValue, true);
    }

    private static DecimalParseResult parse(String stringValue, boolean includeLeadingZerosInPrecision) {
        int precision;
        Matcher matcher = DECIMAL_PATTERN.matcher(stringValue);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid decimal value '" + stringValue + "'");
        }
        String sign = Decimals.getMatcherGroup(matcher, 1);
        if (sign.isEmpty()) {
            sign = "+";
        }
        String leadingZeros = Decimals.getMatcherGroup(matcher, 3);
        String integralPart = Decimals.getMatcherGroup(matcher, 4);
        String fractionalPart = Decimals.getMatcherGroup(matcher, 6);
        int scale = fractionalPart.length();
        if (includeLeadingZerosInPrecision) {
            precision = leadingZeros.length() + integralPart.length() + scale;
        } else {
            precision = integralPart.length() + scale;
            if (precision == 0) {
                precision = 1;
            }
        }
        String unscaledValue = sign + leadingZeros + integralPart + fractionalPart;
        Comparable<Long> value = precision <= 17 ? Long.valueOf(Long.parseLong(unscaledValue)) : Decimals.encodeUnscaledValue(new BigInteger(unscaledValue));
        return new DecimalParseResult(value, DecimalType.createDecimalType(precision, scale));
    }

    private static String getMatcherGroup(Matcher matcher, int group) {
        String groupValue = matcher.group(group);
        if (groupValue == null) {
            groupValue = "";
        }
        return groupValue;
    }

    public static Slice encodeUnscaledValue(BigInteger unscaledValue) {
        Slice result = Slices.allocate(16);
        byte[] bytes = unscaledValue.toByteArray();
        if (unscaledValue.signum() < 0) {
            result.fill((byte)-1);
        }
        result.setBytes(16 - bytes.length, bytes);
        return result;
    }

    public static Slice encodeUnscaledValue(long unscaledValue) {
        Slice result = Slices.allocate(16);
        if (unscaledValue < 0L) {
            result.setLong(0, -1L);
        }
        result.setLong(8, Long.reverseBytes(unscaledValue));
        return result;
    }

    public static Slice encodeScaledValue(BigDecimal value) {
        return Decimals.encodeUnscaledValue(value.unscaledValue());
    }

    public static BigInteger decodeUnscaledValue(Slice valueSlice) {
        return new BigInteger(valueSlice.getBytes());
    }

    public static String toString(long unscaledValue, int scale) {
        return Decimals.toString(Long.toString(unscaledValue), scale);
    }

    public static String toString(Slice unscaledValue, int scale) {
        return Decimals.toString(Decimals.decodeUnscaledValue(unscaledValue), scale);
    }

    public static String toString(BigInteger unscaledValue, int scale) {
        return Decimals.toString(unscaledValue.toString(), scale);
    }

    private static String toString(String unscaledValueString, int scale) {
        StringBuilder resultBuilder = new StringBuilder();
        if (unscaledValueString.startsWith("-")) {
            resultBuilder.append("-");
            unscaledValueString = unscaledValueString.substring(1);
        }
        if (unscaledValueString.length() <= scale) {
            resultBuilder.append("0");
        } else {
            resultBuilder.append(unscaledValueString.substring(0, unscaledValueString.length() - scale));
        }
        if (scale > 0) {
            resultBuilder.append(".");
            if (unscaledValueString.length() < scale) {
                for (int i = 0; i < scale - unscaledValueString.length(); ++i) {
                    resultBuilder.append("0");
                }
                resultBuilder.append(unscaledValueString);
            } else {
                resultBuilder.append(unscaledValueString.substring(unscaledValueString.length() - scale));
            }
        }
        return resultBuilder.toString();
    }

    public static boolean overflows(long value, int precision) {
        if (precision > 17) {
            throw new IllegalArgumentException("expected precision to be less than 17");
        }
        return Math.abs(value) >= Decimals.longTenToNth(precision);
    }

    public static boolean overflows(BigInteger value, int precision) {
        return value.abs().compareTo(Decimals.bigIntegerTenToNth(precision)) >= 0;
    }

    public static boolean overflows(BigInteger value) {
        return value.compareTo(MAX_DECIMAL_UNSCALED_VALUE) > 0 || value.compareTo(MIN_DECIMAL_UNSCALED_VALUE) < 0;
    }

    public static boolean overflows(BigDecimal value, long precision) {
        return (long)value.precision() > precision;
    }

    public static void checkOverflow(BigInteger value) {
        if (Decimals.overflows(value)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("Value is out of range: %s", value.toString()));
        }
    }

    public static void writeBigDecimal(DecimalType decimalType, BlockBuilder blockBuilder, BigDecimal value) {
        decimalType.writeSlice(blockBuilder, Decimals.encodeScaledValue(value));
    }

    public static BigDecimal rescale(BigDecimal value, DecimalType type) {
        if ((value = value.setScale(type.getScale(), RoundingMode.UNNECESSARY)).precision() > type.getPrecision()) {
            throw new IllegalArgumentException("decimal precision larger than column precision");
        }
        return value;
    }

    public static void writeShortDecimal(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeLong(value).closeEntry();
    }

    public static long rescale(long value, int fromScale, int toScale) {
        if (toScale < fromScale) {
            throw new IllegalArgumentException("target scale must be larger than source scale");
        }
        return value * Decimals.longTenToNth(toScale - fromScale);
    }

    public static BigInteger rescale(BigInteger value, int fromScale, int toScale) {
        if (toScale < fromScale) {
            throw new IllegalArgumentException("target scale must be larger than source scale");
        }
        return value.multiply(Decimals.bigIntegerTenToNth(toScale - fromScale));
    }

    public static boolean isShortDecimal(Type type) {
        return type instanceof ShortDecimalType;
    }

    public static boolean isLongDecimal(Type type) {
        return type instanceof LongDecimalType;
    }

    static {
        int i;
        MAX_DECIMAL_UNSCALED_VALUE = new BigInteger(new String(new char[38]).replace("\u0000", "9"));
        MIN_DECIMAL_UNSCALED_VALUE = MAX_DECIMAL_UNSCALED_VALUE.negate();
        DECIMAL_PATTERN = Pattern.compile("(\\+?|-?)((0*)(\\d*))(\\.(\\d+))?");
        LONG_POWERS_OF_TEN = new long[19];
        BIG_INTEGER_POWERS_OF_TEN = new BigInteger[100];
        for (i = 0; i < LONG_POWERS_OF_TEN.length; ++i) {
            Decimals.LONG_POWERS_OF_TEN[i] = Math.round(Math.pow(10.0, i));
        }
        for (i = 0; i < BIG_INTEGER_POWERS_OF_TEN.length; ++i) {
            Decimals.BIG_INTEGER_POWERS_OF_TEN[i] = BigInteger.TEN.pow(i);
        }
    }
}

